/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.qm;

import com.dbeaver.model.ai.RAGDatasourceKey;
import com.dbeaver.model.ai.RAGEmbeddedRecord;
import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.ai.RAGObjectKey;
import com.dbeaver.model.ai.RAGPrefixRelevantRecordFilter;
import com.dbeaver.model.ai.RAGRelevantRecordFilter;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.dbeaver.remote.client.qm.QMClientConfiguration;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;

public class RAGStorageClient
extends AbstractRemoteClient
implements RAGEmbeddingStorage {
    private static final String QUERIES = "rag";

    public RAGStorageClient(QMClientConfiguration clientConfiguration) {
        super(clientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(clientConfiguration.getRefreshSMSessionFunction(), clientConfiguration.getCredentialsProvider()), new DCTrustedServiceInterceptor(clientConfiguration.getDcCertificate())));
    }

    public void save(@NotNull Collection<RAGEmbeddedRecord> records) throws DBException {
        this.executePostRequest(RAGStorageClient.buildEndpointUrl((String[])new String[]{QUERIES, "saveEmbeddings"}), Map.of(), records, BodyConverter.JSON, (Type)((Object)Void.class));
    }

    @NotNull
    public List<RAGEmbeddedRecord> findByKeys(@NotNull Collection<RAGObjectKey> objectKeys) throws DBException {
        return (List)this.executePostRequestVal(RAGStorageClient.buildEndpointUrl((String[])new String[]{QUERIES, "findByKeys"}), Map.of(), objectKeys, BodyConverter.JSON, TypeToken.getParameterized(List.class, (Type[])new Type[]{RAGEmbeddedRecord.class}).getType());
    }

    @NotNull
    public List<RAGEmbeddedRecord> findRelevantRecords(@NotNull RAGRelevantRecordFilter filter) throws DBException {
        return (List)this.executePostRequestVal(RAGStorageClient.buildEndpointUrl((String[])new String[]{QUERIES, "findRelevantRecords"}), Map.of(), filter, BodyConverter.JSON, TypeToken.getParameterized(List.class, (Type[])new Type[]{RAGEmbeddedRecord.class}).getType());
    }

    @NotNull
    public List<RAGEmbeddedRecord> findRelevantRecords(@NotNull RAGPrefixRelevantRecordFilter filter) throws DBException {
        return (List)this.executePostRequestVal(RAGStorageClient.buildEndpointUrl((String[])new String[]{QUERIES, "findPrefixRelevantRecords"}), Map.of(), filter, BodyConverter.JSON, TypeToken.getParameterized(List.class, (Type[])new Type[]{RAGEmbeddedRecord.class}).getType());
    }

    @NotNull
    public List<RAGDatasourceKey> findStaleDatasources(@NotNull Instant olderThan) throws DBException {
        return (List)this.executeGetRequestVal(RAGStorageClient.buildEndpointUrl((String[])new String[]{QUERIES, "findStaleDatasources"}), Map.of("olderThan", olderThan.toString()), TypeToken.getParameterized(List.class, (Type[])new Type[]{RAGDatasourceKey.class}).getType());
    }

    public void deleteByDatasourceIds(@NotNull Collection<RAGDatasourceKey> keys) throws DBException {
        this.executeDeleteRequest(RAGStorageClient.buildEndpointUrl((String[])new String[]{QUERIES, "deleteDatasources"}), Map.of(), keys, (Type)((Object)Void.class));
    }
}

