/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.qm;

import com.dbeaver.model.qm.QMEventManager;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.model.qm.ai.QMAIChatMessage;
import com.dbeaver.model.qm.ai.QMAIChatStorage;
import com.dbeaver.model.qm.ai.QMAIContextObject;
import com.dbeaver.model.qm.ai.QMAIConversationHistory;
import com.dbeaver.model.qm.serializer.QMNestedConnectionInfoSerializer;
import com.dbeaver.model.qm.serializer.QMTypeAdapter;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.interceptor.DCTrustedServiceInterceptor;
import com.dbeaver.remote.client.qm.QMClientConfiguration;
import com.dbeaver.remote.client.qm.RemoteQMCursor;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Request;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPConnectionInformation;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.QMTranslationHistoryItem;
import org.jkiss.dbeaver.model.qm.filters.QMAdminCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMCursorFilter;
import org.jkiss.dbeaver.model.qm.filters.QMQueryFilter;
import org.jkiss.dbeaver.model.qm.meta.QMMDataSourceConnectErrorInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.GsonUtils;

public class QMClient
extends AbstractRemoteClient
implements QMService,
QMEventManager,
QMAIChatStorage {
    private static final String QUERIES = "queries";

    public QMClient(QMClientConfiguration clientConfiguration) {
        super(clientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(clientConfiguration.getRefreshSMSessionFunction(), clientConfiguration.getCredentialsProvider()), new DCTrustedServiceInterceptor(clientConfiguration.getDcCertificate())));
        this.gson = GsonUtils.gsonBuilder().registerTypeAdapter(QMMObject.class, (Object)new QMTypeAdapter()).registerTypeAdapter(QMMTransactionInfo.class, (Object)new QMNestedConnectionInfoSerializer()).registerTypeAdapter(QMMStatementExecuteInfo.class, (Object)new QMNestedConnectionInfoSerializer()).create();
    }

    public void saveEvents(List<QMMetaEvent> event) throws DBException {
        Request request = this.buildPostRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "saveEvent"}), Map.of(), event, BodyConverter.JSON);
        this.executeRequest(request, (Type)((Object)Void.class));
    }

    public String openSession(@NotNull QMSessionInfo sessionInfo) throws DBException {
        return (String)this.executePostRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "openSession"}), sessionInfo, (Type)((Object)String.class));
    }

    public void closeSession(@NotNull String appSessionId) {
        try {
            this.executeGetRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "closeSession", appSessionId}), (Type)((Object)Void.class));
        }
        catch (Exception exception) {}
    }

    @NotNull
    public QMEventCursor getAdminQueryHistoryCursor(@NotNull QMAdminCursorFilter cursorFilter) throws DBException {
        return (QMEventCursor)this.executePostRequestVal(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "getAdminQueryCursor"}), cursorFilter, (Type)((Object)RemoteQMCursor.class));
    }

    @NotNull
    public QMEventCursor getSupervisorQueryHistoryCursor(@NotNull QMAdminCursorFilter cursorFilter) throws DBException {
        return (QMEventCursor)this.executePostRequestVal(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "getSupervisorHistoryCursor"}), cursorFilter, (Type)((Object)RemoteQMCursor.class));
    }

    @NotNull
    public Collection<String> getQueryFilterHistory(@Nullable String sessionId, @NotNull String query) throws DBException {
        return (Collection)this.executeGetRequestVal(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "queryFilterHistory"}), Map.of("query", query), TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
    }

    public void saveQueryFilterValue(@NotNull String sessionId, @NotNull QMQueryFilter queryFilter) throws DBException {
        this.executePutRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "queryFilterValue"}), Map.of("sessionId", sessionId), queryFilter, (Type)((Object)Void.class));
    }

    public void deleteQueryFilterValue(@NotNull String sessionId, @NotNull QMQueryFilter queryFilter) throws DBException {
        this.executeDeleteRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "queryFilterValue"}), Map.of("sessionId", sessionId), queryFilter, (Type)((Object)Void.class));
    }

    @NotNull
    public QMEventCursor getQueryHistoryCursor(@NotNull QMCursorFilter cursorFilter) throws DBException {
        return (QMEventCursor)this.executePostRequestVal(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "getQueryCursor"}), cursorFilter, (Type)((Object)RemoteQMCursor.class));
    }

    public List<QMTranslationHistoryItem> readSmartCompletionHistory(@NotNull String sessionId, @NotNull String dataSourceId, @NotNull String logicalDataSourceName, @Nullable String currentCatalog, @Nullable String currentSchema, int maxCount) throws DBException {
        return (List)this.executeGetRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "readSmartCompletionHistory"}), Map.of("sessionId", sessionId, "dataSourceId", dataSourceId, "logicalDataSourceName", logicalDataSourceName, "currentCatalog", CommonUtils.notEmpty((String)currentCatalog), "currentSchema", CommonUtils.notEmpty((String)currentSchema), "maxCount", maxCount), TypeToken.getParameterized(List.class, (Type[])new Type[]{QMTranslationHistoryItem.class}).getType());
    }

    public void saveSmartCompletionHistory(@NotNull String sessionId, @NotNull String dataSourceId, @NotNull String logicalDataSourceName, @Nullable String currentCatalog, @Nullable String currentSchema, @NotNull String naturalText, @NotNull String sqlText) throws DBException {
        this.executePostRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "saveSmartCompletionHistory"}), Map.of("sessionId", sessionId, "dataSourceId", dataSourceId, "logicalDataSourceName", logicalDataSourceName, "currentCatalog", CommonUtils.notEmpty((String)currentCatalog), "currentSchema", CommonUtils.notEmpty((String)currentSchema), "natualText", naturalText), sqlText, (Type)((Object)String.class));
    }

    public void saveDataSourceConnectError(@NotNull String sessionId, @NotNull QMMDataSourceConnectErrorInfo dataSourceInfo) throws DBException {
        this.executePostRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "saveDataSourceConnectError"}), Map.of("sessionId", sessionId), dataSourceInfo, (Type)((Object)Void.class));
    }

    public String ping() throws DBException {
        return (String)this.executeGetRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "ping"}), (Type)((Object)String.class));
    }

    @NotNull
    public DBPConnectionInformation getInternalDatabaseInformation() throws DBException {
        return (DBPConnectionInformation)this.executeGetRequestVal(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "databaseInfo"}), (Type)((Object)DBPConnectionInformation.class));
    }

    @NotNull
    public List<QMAIConversationHistory> findConversations(@NotNull String sessionId) throws DBException {
        return (List)this.executeGetRequestVal(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversations"}), Map.of("sessionId", sessionId), TypeToken.getParameterized(List.class, (Type[])new Type[]{QMAIConversationHistory.class}).getType());
    }

    public void saveConversation(@NotNull String sessionId, @NotNull QMAIConversationHistory chat) throws DBException {
        this.executePutRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversations"}), Map.of("sessionId", sessionId), chat, (Type)((Object)Void.class));
    }

    public void appendMessages(@NotNull String conversationId, @NotNull List<QMAIChatMessage> messages) throws DBException {
        this.executePutRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversation/messages"}), Map.of("conversationId", conversationId), messages, (Type)((Object)Void.class));
    }

    public void deleteMessage(@NotNull String conversationId, int messageId) throws DBException {
        this.executeDeleteRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversation/message"}), Map.of("conversationId", conversationId, "messageId", messageId), (Type)((Object)Void.class));
    }

    public void extendContext(@NotNull String conversationId, @NotNull Set<QMAIContextObject> extra) throws DBException {
        this.executePutRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversation/context"}), Map.of("conversationId", conversationId), extra, (Type)((Object)Void.class));
    }

    public void deleteConversation(@NotNull String conversationId) throws DBException {
        this.executeDeleteRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversation"}), Map.of("conversationId", conversationId), (Type)((Object)Void.class));
    }

    public void renameConversation(@NotNull String conversationId, @NotNull String newName) throws DBException {
        this.executePutRequest(QMClient.buildEndpointUrl((String[])new String[]{QUERIES, "conversation/name"}), Map.of("conversationId", conversationId), newName, (Type)((Object)Void.class));
    }
}

