/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.LocationBasedCapabilitiesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.CapabilityPropertiesInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.CapabilityPropertiesImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.mysqlflexibleserver.models.CapabilityProperties;
import com.azure.resourcemanager.mysqlflexibleserver.models.LocationBasedCapabilities;

public final class LocationBasedCapabilitiesImpl
implements LocationBasedCapabilities {
    private static final ClientLogger LOGGER = new ClientLogger(LocationBasedCapabilitiesImpl.class);
    private final LocationBasedCapabilitiesClient innerClient;
    private final MySqlManager serviceManager;

    public LocationBasedCapabilitiesImpl(LocationBasedCapabilitiesClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CapabilityProperties> list(String locationName) {
        PagedIterable<CapabilityPropertiesInner> inner = this.serviceClient().list(locationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityPropertiesImpl((CapabilityPropertiesInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<CapabilityProperties> list(String locationName, Context context) {
        PagedIterable<CapabilityPropertiesInner> inner = this.serviceClient().list(locationName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityPropertiesImpl((CapabilityPropertiesInner)inner1, this.manager()));
    }

    private LocationBasedCapabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

