/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.ConfigurationsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ConfigurationInner;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ConfigurationListResultInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ConfigurationImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ConfigurationListResultImpl;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.mysqlflexibleserver.models.Configuration;
import com.azure.resourcemanager.mysqlflexibleserver.models.ConfigurationListForBatchUpdate;
import com.azure.resourcemanager.mysqlflexibleserver.models.ConfigurationListResult;
import com.azure.resourcemanager.mysqlflexibleserver.models.Configurations;

public final class ConfigurationsImpl
implements Configurations {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationsImpl.class);
    private final ConfigurationsClient innerClient;
    private final MySqlManager serviceManager;

    public ConfigurationsImpl(ConfigurationsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Configuration update(String resourceGroupName, String serverName, String configurationName, ConfigurationInner parameters) {
        ConfigurationInner inner = this.serviceClient().update(resourceGroupName, serverName, configurationName, parameters);
        if (inner != null) {
            return new ConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Configuration update(String resourceGroupName, String serverName, String configurationName, ConfigurationInner parameters, Context context) {
        ConfigurationInner inner = this.serviceClient().update(resourceGroupName, serverName, configurationName, parameters, context);
        if (inner != null) {
            return new ConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Configuration> getWithResponse(String resourceGroupName, String serverName, String configurationName, Context context) {
        Response<ConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationImpl((ConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Configuration get(String resourceGroupName, String serverName, String configurationName) {
        ConfigurationInner inner = this.serviceClient().get(resourceGroupName, serverName, configurationName);
        if (inner != null) {
            return new ConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConfigurationListResult batchUpdate(String resourceGroupName, String serverName, ConfigurationListForBatchUpdate parameters) {
        ConfigurationListResultInner inner = this.serviceClient().batchUpdate(resourceGroupName, serverName, parameters);
        if (inner != null) {
            return new ConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConfigurationListResult batchUpdate(String resourceGroupName, String serverName, ConfigurationListForBatchUpdate parameters, Context context) {
        ConfigurationListResultInner inner = this.serviceClient().batchUpdate(resourceGroupName, serverName, parameters, context);
        if (inner != null) {
            return new ConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Configuration> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ConfigurationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationImpl((ConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Configuration> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ConfigurationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationImpl((ConfigurationInner)((Object)inner1), this.manager()));
    }

    private ConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

