/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.DatabaseProperties;
import java.io.IOException;

public final class DatabaseInner
extends ProxyResource {
    private DatabaseProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private DatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String charset() {
        return this.innerProperties() == null ? null : this.innerProperties().charset();
    }

    public DatabaseInner withCharset(String charset) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCharset(charset);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public DatabaseInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseInner)((Object)jsonReader.readObject(reader -> {
            DatabaseInner deserializedDatabaseInner = new DatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabaseInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseInner.innerProperties = DatabaseProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDatabaseInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseInner;
        }));
    }
}

