/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.model.tasks;

import com.dbeaver.ee.mockdata.engine.model.MockGeneratorDescriptor;
import com.dbeaver.ee.mockdata.engine.model.MockGeneratorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.utils.CommonUtils;

public class EntityProperties {
    private static final String PROP_REMOVE_OLD_DATA = "removeOldData";
    private static final String PROP_ROWS_NUMBER = "rowsNumber";
    private static final String PROP_BATCH_SIZE = "batchSize";
    public static final String PROP_ENTITY_PROJECT = "project";
    public static final String PROP_ENTITY_ID = "entityId";
    private static final String KEY_SELECTED_ATTRIBUTE = "selectedAttribute";
    private static final String KEY_SELECTED_GENERATOR = "selectedGenerator";
    private static final String KEY_PRESET_ID = "presetId";
    private static final String KEY_GENERATOR_SECTION = "GENERATOR_SECTION";
    static final String NO_GENERATOR_ID = "<no generator>";
    public static final String PROP_CONFIG = "config";
    private final Map<String, MockGeneratorDescriptor> generatorDescriptors = new HashMap<String, MockGeneratorDescriptor>();
    private final Map<String, AttributeProperties> attributeGenerators = new HashMap<String, AttributeProperties>();
    private final Collection<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
    private final DBSObject inputObject;
    private final DBSDataManipulator dataManipulator;
    private final DBSEntity entity;
    private boolean isInitFromTask;
    @Nullable
    private String selectedAttribute;
    private boolean removeOldData;
    private long rowsNumber = 1000L;
    private int batchSize = 200;

    public EntityProperties(@NotNull DBSObject inputObject) {
        this.inputObject = inputObject;
        this.dataManipulator = (DBSDataManipulator)inputObject;
        this.entity = (DBSEntity)inputObject;
    }

    public void init(DBRProgressMonitor monitor) throws DBException {
        for (DBSAttributeBase attr : CommonUtils.safeCollection((Collection)this.entity.getAttributes(monitor))) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr)) continue;
            this.attributes.add(attr);
        }
        MockGeneratorRegistry generatorRegistry = MockGeneratorRegistry.getInstance();
        for (DBSAttributeBase attribute : this.attributes) {
            AttributeProperties generatorProperties = new AttributeProperties(attribute);
            this.attributeGenerators.put(attribute.getName(), generatorProperties);
            List attributeReferrers = DBUtils.getAttributeReferrers((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)attribute), (boolean)true);
            if (!CommonUtils.isEmpty((Collection)attributeReferrers)) {
                MockGeneratorDescriptor generator = generatorRegistry.getGenerator("fkGenerator");
                this.putGenerator(generatorProperties, generator);
            } else {
                List<MockGeneratorDescriptor> generators = generatorRegistry.findAllGenerators(this.dataManipulator.getDataSource(), (DBSTypedObject)attribute);
                for (MockGeneratorDescriptor generator : generators) {
                    this.putGenerator(generatorProperties, generator);
                }
            }
            this.autoAssignGenerator(generatorProperties);
        }
    }

    public DBSObject getInputObject() {
        return this.inputObject;
    }

    public DBSDataManipulator getDataManipulator() {
        return this.dataManipulator;
    }

    public DBSEntity getEntity() {
        return this.entity;
    }

    public Collection<DBSAttributeBase> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getSelectedAttribute() {
        return this.selectedAttribute;
    }

    public void setSelectedAttribute(@Nullable String selectedAttribute) {
        this.selectedAttribute = selectedAttribute;
    }

    private void putGenerator(AttributeProperties generatorProperties, MockGeneratorDescriptor generator) {
        this.generatorDescriptors.put(generator.getId(), generator);
        generatorProperties.putGeneratorProperties(generator.getId(), new PropertySourceCustom(generator.getProperties(), null));
    }

    public MockGeneratorDescriptor getGeneratorDescriptor(String generatorId) {
        return this.generatorDescriptors.get(generatorId);
    }

    @Nullable
    public MockGeneratorDescriptor findGeneratorForName(DBSAttributeBase attribute, String generatorName) {
        AttributeProperties attributeGeneratorProperties = this.attributeGenerators.get(attribute.getName());
        for (String generatorId : attributeGeneratorProperties.getGenerators()) {
            MockGeneratorDescriptor generatorDescriptor = this.generatorDescriptors.get(generatorId);
            if (!generatorName.equals(generatorDescriptor.getLabel())) continue;
            return generatorDescriptor;
        }
        return null;
    }

    public boolean isInitFromTask() {
        return this.isInitFromTask;
    }

    public boolean isRemoveOldData() {
        return this.removeOldData;
    }

    public void setRemoveOldData(boolean removeOldData) {
        this.removeOldData = removeOldData;
    }

    public long getRowsNumber() {
        return this.rowsNumber;
    }

    public void setRowsNumber(long rowsNumber) {
        this.rowsNumber = rowsNumber;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Map<String, AttributeProperties> getAttributeGenerators() {
        return this.attributeGenerators;
    }

    public AttributeProperties getAttributeProperties(@NotNull DBSAttributeBase attribute) {
        return this.attributeGenerators.get(attribute.getName());
    }

    public void loadFrom(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> map) throws DBException {
        this.init(monitor);
        this.isInitFromTask = true;
        Map configAttrs = (Map)map.get(PROP_CONFIG);
        this.removeOldData = CommonUtils.toBoolean(configAttrs.get(PROP_REMOVE_OLD_DATA));
        try {
            this.rowsNumber = CommonUtils.toLong(configAttrs.get(PROP_ROWS_NUMBER));
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            this.batchSize = CommonUtils.toInt(configAttrs.get(PROP_BATCH_SIZE));
        }
        catch (NumberFormatException numberFormatException) {}
        this.selectedAttribute = CommonUtils.toString((Object)map.get(KEY_SELECTED_ATTRIBUTE));
        for (Map.Entry<String, AttributeProperties> entry : this.attributeGenerators.entrySet()) {
            PropertySourceCustom generatorPropertySource;
            String attributeName = entry.getKey();
            Map mapAttr = (Map)map.get(attributeName);
            String savedGeneratorId = null;
            if (mapAttr != null) {
                Object savedGeneratorIdObj = mapAttr.get(KEY_SELECTED_GENERATOR);
                savedGeneratorId = savedGeneratorIdObj.toString();
            }
            AttributeProperties attrGeneratorProperties = entry.getValue();
            if (NO_GENERATOR_ID.equals(savedGeneratorId)) {
                attrGeneratorProperties.setSelectedGenerator(null);
                attrGeneratorProperties.setPresetId(null);
                continue;
            }
            if (CommonUtils.isEmpty((String)savedGeneratorId)) continue;
            MockGeneratorDescriptor generatorDescriptor = attrGeneratorProperties.getGenerator(savedGeneratorId);
            if (generatorDescriptor != null) {
                attrGeneratorProperties.setSelectedGenerator(generatorDescriptor);
                attrGeneratorProperties.setPresetId((String)mapAttr.get(KEY_PRESET_ID));
            }
            if ((generatorPropertySource = attrGeneratorProperties.getGeneratorProperties()) == null) continue;
            DBPPropertyDescriptor[] dBPPropertyDescriptorArray = generatorPropertySource.getProperties();
            int n = dBPPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
                String key = prop.getId();
                Object savedValue = mapAttr.get(key);
                if (!key.equals("nulls") || !(savedValue instanceof Boolean)) {
                    generatorPropertySource.setPropertyValue(monitor, key, savedValue);
                }
                ++n2;
            }
        }
    }

    public void autoAssignGenerator(AttributeProperties attrGeneratorProperties) {
        DBSAttributeBase attribute = attrGeneratorProperties.getAttribute();
        if (attribute.isAutoGenerated()) {
            attrGeneratorProperties.setSelectedGenerator(null);
            return;
        }
        String attributeName = attribute.getName().toLowerCase();
        Set<String> attrGeneratorIds = attrGeneratorProperties.getGenerators();
        boolean found = false;
        for (String generatorId : attrGeneratorIds) {
            MockGeneratorDescriptor generatorDescriptor = this.getGeneratorDescriptor(generatorId);
            for (String tag : generatorDescriptor.getTags()) {
                if (!attributeName.contains(tag)) continue;
                attrGeneratorProperties.setSelectedGenerator(generatorDescriptor);
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            if (attrGeneratorIds.contains("fkGenerator")) {
                this.setSelectedGenerator(attrGeneratorProperties, "fkGenerator");
                return;
            }
            switch (attribute.getDataKind()) {
                case BOOLEAN: {
                    this.setSelectedGenerator(attrGeneratorProperties, "booleanRandomGenerator");
                    break;
                }
                case DATETIME: {
                    this.setSelectedGenerator(attrGeneratorProperties, "dateRandomGenerator");
                    break;
                }
                case NUMERIC: {
                    this.setSelectedGenerator(attrGeneratorProperties, "numericAdvancedGenerator");
                    break;
                }
                case STRING: {
                    this.setSelectedGenerator(attrGeneratorProperties, "stringTextGenerator");
                }
            }
        }
    }

    private void setSelectedGenerator(@NotNull AttributeProperties attrGeneratorProperties, @Nullable String generatorId) {
        if (generatorId == null) {
            attrGeneratorProperties.setSelectedGenerator(null);
        } else {
            attrGeneratorProperties.setSelectedGenerator(attrGeneratorProperties.getGenerator(generatorId));
        }
    }

    void saveTo(@NotNull Map<String, Object> map) {
        HashMap<String, Object> configAttrs = new HashMap<String, Object>();
        configAttrs.put(PROP_ENTITY_PROJECT, this.entity.getDataSource().getContainer().getProject().getName());
        configAttrs.put(PROP_ENTITY_ID, DBUtils.getObjectFullId((DBSObject)this.entity));
        configAttrs.put(PROP_REMOVE_OLD_DATA, this.removeOldData);
        configAttrs.put(PROP_ROWS_NUMBER, this.rowsNumber);
        configAttrs.put(PROP_BATCH_SIZE, this.batchSize);
        configAttrs.put(KEY_SELECTED_ATTRIBUTE, this.selectedAttribute);
        for (Map.Entry<String, AttributeProperties> attrEntry : this.attributeGenerators.entrySet()) {
            HashMap<String, String> mapAttr = new HashMap<String, String>();
            AttributeProperties attrGeneratorProperties = attrEntry.getValue();
            MockGeneratorDescriptor selectedGenerator = attrGeneratorProperties.getSelectedGenerator();
            if (selectedGenerator == null) {
                mapAttr.put(KEY_SELECTED_GENERATOR, NO_GENERATOR_ID);
                mapAttr.put(KEY_PRESET_ID, null);
            } else {
                mapAttr.put(KEY_SELECTED_GENERATOR, selectedGenerator.getId());
                mapAttr.put(KEY_PRESET_ID, attrGeneratorProperties.getPresetId());
                PropertySourceCustom generatorPropertySource = attrGeneratorProperties.getGeneratorProperties();
                if (generatorPropertySource != null) {
                    Map properties = generatorPropertySource.getPropertiesWithDefaults();
                    mapAttr.putAll(properties);
                }
            }
            map.put(attrEntry.getKey(), mapAttr);
        }
        map.put(PROP_CONFIG, configAttrs);
    }

    public class AttributeProperties {
        private final Map<String, PropertySourceCustom> generators = new TreeMap<String, PropertySourceCustom>();
        private final DBSAttributeBase attribute;
        @Nullable
        private MockGeneratorDescriptor selectedGenerator;
        @Nullable
        private String presetId;

        public AttributeProperties(DBSAttributeBase attribute) {
            this.attribute = attribute;
        }

        public DBSAttributeBase getAttribute() {
            return this.attribute;
        }

        @Nullable
        public MockGeneratorDescriptor getSelectedGenerator() {
            return this.selectedGenerator;
        }

        public Set<String> getGenerators() {
            return this.generators.keySet();
        }

        public void setSelectedGenerator(@Nullable MockGeneratorDescriptor generator) {
            this.selectedGenerator = generator;
        }

        public void putGeneratorProperties(String generatorId, PropertySourceCustom propertySource) {
            this.generators.put(generatorId, propertySource);
        }

        public PropertySourceCustom getGeneratorProperties() {
            return this.selectedGenerator == null ? null : this.generators.get(this.selectedGenerator.getId());
        }

        @Nullable
        public String getPresetId() {
            return this.presetId;
        }

        public void setPresetId(@Nullable String presetId) {
            this.presetId = presetId;
        }

        public boolean isEmpty() {
            return this.generators.isEmpty();
        }

        public MockGeneratorDescriptor getGenerator(String generatorId) {
            return EntityProperties.this.generatorDescriptors.get(generatorId);
        }
    }
}

