/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.provider;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.DBPCloudParametersConfiguration;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class BaseCloudParametersProviderEditor<CLOUD_CONFIG extends CPCloudConfiguration<?>, PARAMETERS extends DBPCloudParametersConfiguration>
implements IObjectPropertyConfigurator<PARAMETERS, PARAMETERS> {
    private static final Log log = Log.getLog(BaseCloudParametersProviderEditor.class);
    private final List<CLOUD_CONFIG> cloudConfigurations = new ArrayList<CLOUD_CONFIG>();
    private final Class<CLOUD_CONFIG> cloudClass;
    private Combo cloudCombo;
    private PARAMETERS currentParameters;
    private CLOUD_CONFIG selectedCloud;

    public BaseCloudParametersProviderEditor(Class<CLOUD_CONFIG> cloudClass) {
        this.cloudClass = cloudClass;
    }

    public void createControl(@NotNull Composite parent, PARAMETERS object, @NotNull Runnable propertyChangeListener) {
        this.cloudCombo = UIUtils.createLabelCombo((Composite)parent, (String)"Cloud", (String)"", (int)12);
        this.cloudCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selectedCloud = (CPCloudConfiguration)this.cloudConfigurations.get(this.cloudCombo.getSelectionIndex());
            this.onCloudChange(this.selectedCloud);
        }));
    }

    public void loadSettings(@NotNull PARAMETERS parameters) {
        this.currentParameters = parameters;
        this.cloudCombo.removeAll();
        this.cloudConfigurations.clear();
        try {
            for (CloudConfigurationDescriptor cloudConfig : CloudConfigurationDescriptor.getAllCloudConfigurations()) {
                if (!this.cloudClass.isAssignableFrom(cloudConfig.getConfiguration().getClass())) continue;
                this.cloudConfigurations.add(cloudConfig.getConfiguration());
            }
            this.selectedCloud = parameters.getCloudId() == null ? null : (CPCloudConfiguration)this.cloudConfigurations.stream().filter(c -> Objects.equals(c.getCloudId(), parameters.getCloudId())).findFirst().orElse(null);
            for (CPCloudConfiguration cc : this.cloudConfigurations) {
                this.cloudCombo.add(cc.getCloudName());
            }
            if (this.selectedCloud != null) {
                this.cloudCombo.setText(this.selectedCloud.getCloudName());
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Configuration error", "Error loading cloud configurations", (Throwable)e);
        }
    }

    public void saveSettings(@NotNull PARAMETERS parameters) {
        if (this.selectedCloud != null) {
            parameters.setCloudId(this.selectedCloud.getCloudId());
        } else {
            parameters.setCloudId(null);
        }
    }

    public void resetSettings(@NotNull PARAMETERS parameters) {
    }

    public boolean isComplete() {
        return this.selectedCloud != null;
    }

    public PARAMETERS getCurrentParameters() {
        return this.currentParameters;
    }

    protected CLOUD_CONFIG getCurrentCloud() {
        return this.selectedCloud;
    }

    protected void onCloudChange(CLOUD_CONFIG selectedCloud) {
    }
}

