/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.statistic.CloudFeature;
import com.dbeaver.cloud.ui.explorer.CloudExplorerPanel;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;

public class CloudExplorerDialog
extends AbstractPopupPanel {
    private static CloudExplorerDialog sharedInstance;
    private CloudExplorerPanel explorerPanel;

    private CloudExplorerDialog(Shell parent) {
        super(parent, CloudUIMessages.cloud_explorer_dialog_title);
    }

    public static synchronized void show(@NotNull Shell shell) {
        if (sharedInstance != null) {
            sharedInstance.getShell().forceFocus();
            return;
        }
        sharedInstance = new CloudExplorerDialog(shell);
        sharedInstance.setModeless(true);
        sharedInstance.open();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)CloudExplorerDialog.class.getSimpleName());
    }

    protected Composite createDialogArea(Composite parent) {
        Composite group = super.createDialogArea(parent);
        this.explorerPanel = new CloudExplorerPanel(true);
        this.explorerPanel.setContainer(lock -> this.setModeless(!lock));
        this.explorerPanel.createControl(group);
        DatabaseNavigatorTree explorerTree = this.explorerPanel.getExplorerTree();
        this.closeOnFocusLost(new Control[]{explorerTree, explorerTree.getFilterControl(), explorerTree.getViewer().getControl()});
        return group;
    }

    public boolean close() {
        sharedInstance = null;
        return super.close();
    }

    public CloudExplorerPanel getExplorerPanel() {
        return this.explorerPanel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public int open() {
        CloudFeature.CLOUD_EXPLORER_OPEN.use();
        return super.open();
    }
}

