/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.tm.client;

import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.tm.client.TMClientConfiguration;
import com.dbeaver.remote.client.tm.model.TMTaskInfoService;
import com.dbeaver.remote.client.tm.model.TMTaskRun;
import com.dbeaver.remote.client.tm.model.TMTaskRuns;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.utils.GsonDateAdapter;
import org.jkiss.utils.GsonUtils;

public class TMTaskInfoClient
extends AbstractRemoteClient
implements TMTaskInfoService {
    public TMTaskInfoClient(TMClientConfiguration clientConfiguration) {
        super(clientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(clientConfiguration.getRefreshSMSessionFunction(), clientConfiguration.getCredentialsProvider())));
        this.gson = GsonUtils.gsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)GsonDateAdapter.INSTANCE).create();
    }

    @Override
    @NotNull
    public TMTaskRuns[] getAllTaskRuns(@NotNull String projectId) throws DBException {
        return (TMTaskRuns[])this.executeGetRequestVal(TMTaskInfoClient.buildEndpointUrl((String[])new String[]{"tasks/info", projectId, "runs"}), (Type)((Object)TMTaskRuns[].class));
    }

    @Override
    @NotNull
    public TMTaskRun[] getAllTaskRuns(@NotNull String projectId, @NotNull String taskId) throws DBException {
        return (TMTaskRun[])this.executeGetRequestVal(TMTaskInfoClient.buildEndpointUrl((String[])new String[]{"tasks/info", projectId, taskId, "runs"}), (Type)((Object)TMTaskRun[].class));
    }

    @Override
    @Nullable
    public TMTaskRun getLatestTaskRun(@NotNull String projectId, @NotNull String taskId) throws DBException {
        return (TMTaskRun)this.executeGetRequest(TMTaskInfoClient.buildEndpointUrl((String[])new String[]{"tasks/info", projectId, taskId, "runs/latest"}), (Type)((Object)TMTaskRun.class));
    }

    @Override
    @Nullable
    public TMTaskRun getTaskRun(@NotNull String projectId, @NotNull String taskId, @NotNull String runId) throws DBException {
        return (TMTaskRun)this.executeGetRequest(TMTaskInfoClient.buildEndpointUrl((String[])new String[]{"tasks/info", projectId, taskId, "runs", runId}), (Type)((Object)TMTaskRun.class));
    }

    @Override
    public InputStream readTaskOutputFile(@NotNull String projectId, @NotNull String taskId, @NotNull String runId, @NotNull String fileName) throws DBException {
        Map<String, String> params = Map.of("fileName", fileName);
        return (InputStream)this.executeGetRequest(TMTaskInfoClient.buildEndpointUrl((String[])new String[]{"tasks/info", projectId, taskId, "runs", runId, "output"}), params, (Type)((Object)InputStream.class));
    }

    @Override
    public InputStream readTaskRunLogs(@NotNull String projectId, @NotNull String taskId, @NotNull String runId) throws DBException {
        return (InputStream)this.executeGetRequest(TMTaskInfoClient.buildEndpointUrl((String[])new String[]{"tasks/info", projectId, taskId, "runs", runId, "logs"}), (Type)((Object)InputStream.class));
    }
}

