/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.tm.client;

import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.interceptor.DCAuthInterceptor;
import com.dbeaver.remote.client.tm.client.TMClientConfiguration;
import com.dbeaver.remote.client.tm.model.TMTaskExecutionService;
import com.dbeaver.remote.client.tm.model.TMTaskSchedule;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.utils.GsonDateAdapter;
import org.jkiss.utils.GsonUtils;

public class TMTaskExecutionClient
extends AbstractRemoteClient
implements TMTaskExecutionService {
    public TMTaskExecutionClient(TMClientConfiguration clientConfiguration) {
        super(clientConfiguration.getApiUrl(), List.of(new DCAuthInterceptor(clientConfiguration.getRefreshSMSessionFunction(), clientConfiguration.getCredentialsProvider())));
        this.gson = GsonUtils.gsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)GsonDateAdapter.INSTANCE).create();
    }

    @Override
    @NotNull
    public List<String> getSupportedTasks() throws DBException {
        return (List)this.executeGetRequestVal("tasks/execution", Map.of(), TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
    }

    @Override
    public void runTask(@NotNull String projectId, @NotNull String taskId) throws DBException {
        this.executePostRequest(TMTaskExecutionClient.buildEndpointUrl((String[])new String[]{"tasks/execution", projectId, taskId}), Map.of(), (Type)((Object)Void.class));
    }

    @Override
    public void scheduleTask(@NotNull String projectId, @NotNull String taskId, @NotNull DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        this.executePostRequest(TMTaskExecutionClient.buildEndpointUrl((String[])new String[]{"tasks/execution", projectId, taskId, "schedule"}), scheduleConfiguration, (Type)((Object)Void.class));
    }

    @Override
    public void removeTaskSchedule(@NotNull String projectId, @NotNull String taskId) throws DBException {
        this.executeDeleteRequest(TMTaskExecutionClient.buildEndpointUrl((String[])new String[]{"tasks/execution", projectId, taskId, "schedule"}), (Type)((Object)Void.class));
    }

    @Override
    @NotNull
    public List<TMTaskSchedule> getAllTaskSchedules(@Nullable String projectId) throws DBException {
        return (List)this.executeGetRequestVal(TMTaskExecutionClient.buildEndpointUrl((String[])new String[]{"tasks/execution", "scheduled"}), projectId == null ? Map.of() : Map.of("project", projectId), TypeToken.getParameterized(List.class, (Type[])new Type[]{TMTaskSchedule.class}).getType());
    }
}

