/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OperationDisplay;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OperationOrigin;
import java.io.IOException;
import java.util.Map;

public final class Operation
implements JsonSerializable<Operation> {
    private String name;
    private OperationDisplay display;
    private Boolean isDataAction;
    private OperationOrigin origin;
    private Map<String, Object> properties;

    public String name() {
        return this.name;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public Operation withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationOrigin origin() {
        return this.origin;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    public static Operation fromJson(JsonReader jsonReader) throws IOException {
        return (Operation)jsonReader.readObject(reader -> {
            Operation deserializedOperation = new Operation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperation.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperation.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperation.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperation.origin = OperationOrigin.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedOperation.properties = properties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperation;
        });
    }
}

