/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerPublicNetworkAccessState;
import java.io.IOException;

public final class Network
implements JsonSerializable<Network> {
    private ServerPublicNetworkAccessState publicNetworkAccess;
    private String delegatedSubnetResourceId;
    private String privateDnsZoneArmResourceId;

    public ServerPublicNetworkAccessState publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public Network withPublicNetworkAccess(ServerPublicNetworkAccessState publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public String delegatedSubnetResourceId() {
        return this.delegatedSubnetResourceId;
    }

    public Network withDelegatedSubnetResourceId(String delegatedSubnetResourceId) {
        this.delegatedSubnetResourceId = delegatedSubnetResourceId;
        return this;
    }

    public String privateDnsZoneArmResourceId() {
        return this.privateDnsZoneArmResourceId;
    }

    public Network withPrivateDnsZoneArmResourceId(String privateDnsZoneArmResourceId) {
        this.privateDnsZoneArmResourceId = privateDnsZoneArmResourceId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("delegatedSubnetResourceId", this.delegatedSubnetResourceId);
        jsonWriter.writeStringField("privateDnsZoneArmResourceId", this.privateDnsZoneArmResourceId);
        return jsonWriter.writeEndObject();
    }

    public static Network fromJson(JsonReader jsonReader) throws IOException {
        return (Network)jsonReader.readObject(reader -> {
            Network deserializedNetwork = new Network();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNetwork.publicNetworkAccess = ServerPublicNetworkAccessState.fromString(reader.getString());
                    continue;
                }
                if ("delegatedSubnetResourceId".equals(fieldName)) {
                    deserializedNetwork.delegatedSubnetResourceId = reader.getString();
                    continue;
                }
                if ("privateDnsZoneArmResourceId".equals(fieldName)) {
                    deserializedNetwork.privateDnsZoneArmResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetwork;
        });
    }
}

