/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerSku;
import java.io.IOException;

public final class DbServerMetadata
implements JsonSerializable<DbServerMetadata> {
    private String location;
    private String version;
    private Integer storageMb;
    private ServerSku sku;

    public String location() {
        return this.location;
    }

    public String version() {
        return this.version;
    }

    public DbServerMetadata withVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer storageMb() {
        return this.storageMb;
    }

    public DbServerMetadata withStorageMb(Integer storageMb) {
        this.storageMb = storageMb;
        return this;
    }

    public ServerSku sku() {
        return this.sku;
    }

    public DbServerMetadata withSku(ServerSku sku) {
        this.sku = sku;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeNumberField("storageMb", (Number)this.storageMb);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static DbServerMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (DbServerMetadata)jsonReader.readObject(reader -> {
            DbServerMetadata deserializedDbServerMetadata = new DbServerMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedDbServerMetadata.location = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedDbServerMetadata.version = reader.getString();
                    continue;
                }
                if ("storageMb".equals(fieldName)) {
                    deserializedDbServerMetadata.storageMb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDbServerMetadata.sku = ServerSku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDbServerMetadata;
        });
    }
}

