/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ArmServerKeyType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.KeyStatusEnum;
import java.io.IOException;

public final class DataEncryption
implements JsonSerializable<DataEncryption> {
    private String primaryKeyUri;
    private String primaryUserAssignedIdentityId;
    private String geoBackupKeyUri;
    private String geoBackupUserAssignedIdentityId;
    private ArmServerKeyType type;
    private KeyStatusEnum primaryEncryptionKeyStatus;
    private KeyStatusEnum geoBackupEncryptionKeyStatus;

    public String primaryKeyUri() {
        return this.primaryKeyUri;
    }

    public DataEncryption withPrimaryKeyUri(String primaryKeyUri) {
        this.primaryKeyUri = primaryKeyUri;
        return this;
    }

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public DataEncryption withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public String geoBackupKeyUri() {
        return this.geoBackupKeyUri;
    }

    public DataEncryption withGeoBackupKeyUri(String geoBackupKeyUri) {
        this.geoBackupKeyUri = geoBackupKeyUri;
        return this;
    }

    public String geoBackupUserAssignedIdentityId() {
        return this.geoBackupUserAssignedIdentityId;
    }

    public DataEncryption withGeoBackupUserAssignedIdentityId(String geoBackupUserAssignedIdentityId) {
        this.geoBackupUserAssignedIdentityId = geoBackupUserAssignedIdentityId;
        return this;
    }

    public ArmServerKeyType type() {
        return this.type;
    }

    public DataEncryption withType(ArmServerKeyType type) {
        this.type = type;
        return this;
    }

    public KeyStatusEnum primaryEncryptionKeyStatus() {
        return this.primaryEncryptionKeyStatus;
    }

    public DataEncryption withPrimaryEncryptionKeyStatus(KeyStatusEnum primaryEncryptionKeyStatus) {
        this.primaryEncryptionKeyStatus = primaryEncryptionKeyStatus;
        return this;
    }

    public KeyStatusEnum geoBackupEncryptionKeyStatus() {
        return this.geoBackupEncryptionKeyStatus;
    }

    public DataEncryption withGeoBackupEncryptionKeyStatus(KeyStatusEnum geoBackupEncryptionKeyStatus) {
        this.geoBackupEncryptionKeyStatus = geoBackupEncryptionKeyStatus;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryKeyURI", this.primaryKeyUri);
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("geoBackupKeyURI", this.geoBackupKeyUri);
        jsonWriter.writeStringField("geoBackupUserAssignedIdentityId", this.geoBackupUserAssignedIdentityId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("primaryEncryptionKeyStatus", this.primaryEncryptionKeyStatus == null ? null : this.primaryEncryptionKeyStatus.toString());
        jsonWriter.writeStringField("geoBackupEncryptionKeyStatus", this.geoBackupEncryptionKeyStatus == null ? null : this.geoBackupEncryptionKeyStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (DataEncryption)jsonReader.readObject(reader -> {
            DataEncryption deserializedDataEncryption = new DataEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryKeyURI".equals(fieldName)) {
                    deserializedDataEncryption.primaryKeyUri = reader.getString();
                    continue;
                }
                if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedDataEncryption.primaryUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("geoBackupKeyURI".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupKeyUri = reader.getString();
                    continue;
                }
                if ("geoBackupUserAssignedIdentityId".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataEncryption.type = ArmServerKeyType.fromString(reader.getString());
                    continue;
                }
                if ("primaryEncryptionKeyStatus".equals(fieldName)) {
                    deserializedDataEncryption.primaryEncryptionKeyStatus = KeyStatusEnum.fromString(reader.getString());
                    continue;
                }
                if ("geoBackupEncryptionKeyStatus".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupEncryptionKeyStatus = KeyStatusEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataEncryption;
        });
    }
}

