/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualEndpointsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualEndpointResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpoints;

public final class VirtualEndpointsImpl
implements VirtualEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualEndpointsImpl.class);
    private final VirtualEndpointsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public VirtualEndpointsImpl(VirtualEndpointsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String virtualEndpointName) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualEndpointName);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String virtualEndpointName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualEndpointName, context);
    }

    @Override
    public Response<VirtualEndpointResource> getWithResponse(String resourceGroupName, String serverName, String virtualEndpointName, Context context) {
        Response<VirtualEndpointResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, virtualEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualEndpointResourceImpl((VirtualEndpointResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualEndpointResource get(String resourceGroupName, String serverName, String virtualEndpointName) {
        VirtualEndpointResourceInner inner = this.serviceClient().get(resourceGroupName, serverName, virtualEndpointName);
        if (inner != null) {
            return new VirtualEndpointResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<VirtualEndpointResource> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<VirtualEndpointResourceInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualEndpointResourceImpl((VirtualEndpointResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<VirtualEndpointResource> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<VirtualEndpointResourceInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualEndpointResourceImpl((VirtualEndpointResourceInner)inner1, this.manager()));
    }

    @Override
    public VirtualEndpointResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        return (VirtualEndpointResource)this.getWithResponse(resourceGroupName, serverName, virtualEndpointName, Context.NONE).getValue();
    }

    @Override
    public Response<VirtualEndpointResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, virtualEndpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualEndpointName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualEndpointName, context);
    }

    private VirtualEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualEndpointResourceImpl define(String name) {
        return new VirtualEndpointResourceImpl(name, this.manager());
    }
}

