/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForUpdate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import java.io.IOException;

public final class ServerPropertiesForUpdate
implements JsonSerializable<ServerPropertiesForUpdate> {
    private String administratorLogin;
    private String administratorLoginPassword;
    private ServerVersion version;
    private Storage storage;
    private Backup backup;
    private HighAvailability highAvailability;
    private MaintenanceWindow maintenanceWindow;
    private AuthConfig authConfig;
    private DataEncryption dataEncryption;
    private CreateModeForUpdate createMode;
    private ReplicationRole replicationRole;
    private Replica replica;
    private Network network;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerPropertiesForUpdate withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerPropertiesForUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerPropertiesForUpdate withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public Storage storage() {
        return this.storage;
    }

    public ServerPropertiesForUpdate withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public Backup backup() {
        return this.backup;
    }

    public ServerPropertiesForUpdate withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    public ServerPropertiesForUpdate withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ServerPropertiesForUpdate withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public AuthConfig authConfig() {
        return this.authConfig;
    }

    public ServerPropertiesForUpdate withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    public ServerPropertiesForUpdate withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    public CreateModeForUpdate createMode() {
        return this.createMode;
    }

    public ServerPropertiesForUpdate withCreateMode(CreateModeForUpdate createMode) {
        this.createMode = createMode;
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public ServerPropertiesForUpdate withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public Replica replica() {
        return this.replica;
    }

    public ServerPropertiesForUpdate withReplica(Replica replica) {
        this.replica = replica;
        return this;
    }

    public Network network() {
        return this.network;
    }

    public ServerPropertiesForUpdate withNetwork(Network network) {
        this.network = network;
        return this;
    }

    public void validate() {
        if (this.storage() != null) {
            this.storage().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.highAvailability() != null) {
            this.highAvailability().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
        if (this.authConfig() != null) {
            this.authConfig().validate();
        }
        if (this.dataEncryption() != null) {
            this.dataEncryption().validate();
        }
        if (this.replica() != null) {
            this.replica().validate();
        }
        if (this.network() != null) {
            this.network().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeJsonField("storage", (JsonSerializable)this.storage);
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("highAvailability", (JsonSerializable)this.highAvailability);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        jsonWriter.writeJsonField("authConfig", (JsonSerializable)this.authConfig);
        jsonWriter.writeJsonField("dataEncryption", (JsonSerializable)this.dataEncryption);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("replicationRole", this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("replica", (JsonSerializable)this.replica);
        jsonWriter.writeJsonField("network", (JsonSerializable)this.network);
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForUpdate)jsonReader.readObject(reader -> {
            ServerPropertiesForUpdate deserializedServerPropertiesForUpdate = new ServerPropertiesForUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.version = ServerVersion.fromString(reader.getString());
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.storage = Storage.fromJson(reader);
                    continue;
                }
                if ("backup".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.backup = Backup.fromJson(reader);
                    continue;
                }
                if ("highAvailability".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.highAvailability = HighAvailability.fromJson(reader);
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                    continue;
                }
                if ("authConfig".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.authConfig = AuthConfig.fromJson(reader);
                    continue;
                }
                if ("dataEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.dataEncryption = DataEncryption.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.createMode = CreateModeForUpdate.fromString(reader.getString());
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.replicationRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replica".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.replica = Replica.fromJson(reader);
                    continue;
                }
                if ("network".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.network = Network.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForUpdate;
        });
    }
}

