/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Origin;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ServerBackupProperties
implements JsonSerializable<ServerBackupProperties> {
    private Origin backupType;
    private OffsetDateTime completedTime;
    private String source;

    public Origin backupType() {
        return this.backupType;
    }

    public ServerBackupProperties withBackupType(Origin backupType) {
        this.backupType = backupType;
        return this;
    }

    public OffsetDateTime completedTime() {
        return this.completedTime;
    }

    public ServerBackupProperties withCompletedTime(OffsetDateTime completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    public String source() {
        return this.source;
    }

    public ServerBackupProperties withSource(String source) {
        this.source = source;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("backupType", this.backupType == null ? null : this.backupType.toString());
        jsonWriter.writeStringField("completedTime", this.completedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.completedTime));
        jsonWriter.writeStringField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    public static ServerBackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerBackupProperties)jsonReader.readObject(reader -> {
            ServerBackupProperties deserializedServerBackupProperties = new ServerBackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupType".equals(fieldName)) {
                    deserializedServerBackupProperties.backupType = Origin.fromString(reader.getString());
                    continue;
                }
                if ("completedTime".equals(fieldName)) {
                    deserializedServerBackupProperties.completedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedServerBackupProperties.source = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerBackupProperties;
        });
    }
}

