/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerBackupProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Origin;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ServerBackupInner
extends ProxyResource {
    private ServerBackupProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ServerBackupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Origin backupType() {
        return this.innerProperties() == null ? null : this.innerProperties().backupType();
    }

    public ServerBackupInner withBackupType(Origin backupType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerBackupProperties();
        }
        this.innerProperties().withBackupType(backupType);
        return this;
    }

    public OffsetDateTime completedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().completedTime();
    }

    public ServerBackupInner withCompletedTime(OffsetDateTime completedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerBackupProperties();
        }
        this.innerProperties().withCompletedTime(completedTime);
        return this;
    }

    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public ServerBackupInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerBackupProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ServerBackupInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerBackupInner)((Object)jsonReader.readObject(reader -> {
            ServerBackupInner deserializedServerBackupInner = new ServerBackupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServerBackupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerBackupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServerBackupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerBackupInner.innerProperties = ServerBackupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedServerBackupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerBackupInner;
        }));
    }
}

