/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.udbt.protocol;

import com.dbeaver.model.udbt.UdbtEndpoint;
import com.dbeaver.model.udbt.protocol.UdbtWsListener;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Session;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.ee10.websocket.jakarta.client.JakartaWebSocketClientContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.utils.WSClientUtils;

public final class UdbtWsTransport
implements AutoCloseable {
    private static final Log log = Log.getLog(UdbtWsTransport.class);
    private static final String HTTP_CLIENT_CLASS = "org.eclipse.jetty.client.HttpClient";
    private static final String HTTP_PROXY_CLASS = "org.eclipse.jetty.client.HttpProxy";
    private final UdbtEndpoint endpoint;
    private final ServerSocketChannel server;
    private final int port;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final JakartaWebSocketClientContainer webSocketClient;
    private final SMCredentialsProvider credentialsProvider;

    public UdbtWsTransport(@NotNull UdbtEndpoint endpoint, @NotNull SMCredentialsProvider credentialsProvider) throws Exception {
        this.endpoint = endpoint;
        this.credentialsProvider = credentialsProvider;
        WSClientUtils.ProxyInfo proxyInfo = WSClientUtils.findProxyInfo();
        HttpClient httpClient = new HttpClient();
        if (proxyInfo.exists()) {
            httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new HttpProxy(proxyInfo.getHost(), proxyInfo.getPort()));
        }
        this.webSocketClient = new JakartaWebSocketClientContainer(httpClient);
        this.webSocketClient.start();
        this.server = ServerSocketChannel.open();
        this.server.bind(new InetSocketAddress(0));
        this.port = ((InetSocketAddress)this.server.getLocalAddress()).getPort();
        this.executor.submit(() -> {
            Thread.currentThread().setName(this.getClass().getSimpleName() + " " + Integer.toHexString(this.hashCode()) + " C->S");
            return this.listen();
        });
    }

    public int getLocalPort() {
        return this.port;
    }

    @Override
    public void close() throws Exception {
        if (this.webSocketClient.isStarted()) {
            this.webSocketClient.stop();
        }
        this.server.close();
        this.executor.shutdownNow();
    }

    private boolean isRunning() {
        return this.server.isOpen();
    }

    private Void listen() throws Exception {
        log.debug((Object)("[UDBT] UDBT started at " + String.valueOf(this.server.getLocalAddress())));
        Throwable throwable = null;
        Object var2_3 = null;
        try (Selector selector = Selector.open();){
            this.server.configureBlocking(false);
            this.server.register(selector, 16);
            while (this.isRunning()) {
                selector.select();
                if (!this.isRunning()) break;
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        SocketChannel channel = this.server.accept();
                        try {
                            this.serve(channel);
                        }
                        catch (Exception e) {
                            log.error((Object)("[UDBT] Failed to establish connection from " + String.valueOf(channel.getRemoteAddress())), (Throwable)e);
                        }
                    }
                    it.remove();
                }
            }
            log.trace((Object)"Exiting the loop due to connection closed");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private void serve(@NotNull SocketChannel channel) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[UDBT] Accepted connection from " + String.valueOf(channel.getRemoteAddress())));
        }
        if (this.credentialsProvider.getActiveUserCredentials() == null) {
            throw new DBException("User not authorized");
        }
        UUID sessionId = UUID.randomUUID();
        ClientEndpointConfig clientEndpointConfig = this.getClientEndpointConfiguration(this.credentialsProvider.getActiveUserCredentials().getSmAccessToken(), sessionId);
        try {
            UdbtWsListener listener = new UdbtWsListener(this.executor, channel, sessionId);
            Session session = this.webSocketClient.connectToServer((Endpoint)listener, clientEndpointConfig, this.endpoint.webSocketUri());
            if (session == null) {
                throw new DBException("Failed to establish connection to the proxy server");
            }
        }
        catch (Exception e) {
            throw new DBException("Connection failed", e.getCause());
        }
    }

    private ClientEndpointConfig getClientEndpointConfiguration(final @NotNull String smAccessToken, final @NotNull UUID sessionId) {
        ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

            public void beforeRequest(Map<String, List<String>> headers) {
                headers.put("X-Udbt-ProjectId", List.of(UdbtWsTransport.this.endpoint.projectId()));
                headers.put("X-Udbt-DataSourceId", List.of(UdbtWsTransport.this.endpoint.dataSourceId()));
                headers.put("SM-Auth-Token", List.of(smAccessToken));
                headers.put("X-Udbt-Id", List.of(sessionId.toString()));
            }
        };
        return ClientEndpointConfig.Builder.create().configurator(configurator).build();
    }
}

