/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.udbt;

import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.model.udbt.UdbtEndpoint;
import com.dbeaver.model.udbt.protocol.UdbtWsTransport;
import com.dbeaver.remote.client.MSServiceType;
import com.dbeaver.remote.client.dc.DCUserConfiguration;
import com.dbeaver.remote.client.dc.DCUserConfigurationProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class UdbtTunnel
implements DBWTunnel {
    public static final String ID = "udbt";
    public static final String TUNNEL_LOCAL_HOST = "localhost";
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private UdbtWsTransport transport;

    @NotNull
    public DBPConnectionConfiguration initializeHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull DBPConnectionConfiguration info) throws DBException {
        if (DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return info;
        }
        DBPDataSourceContainer dataSourceContainer = configuration.getDataSource();
        if (dataSourceContainer == null) {
            throw new DBException("Data source is not available");
        }
        this.connect(dataSourceContainer, info);
        return info;
    }

    public void invalidateHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return;
        }
        if (phase == DBCInvalidatePhase.BEFORE_INVALIDATE) {
            this.disconnect();
        }
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            this.connect(dataSource.getContainer(), dataSource.getContainer().getActualConnectionConfiguration());
        }
    }

    public void closeTunnel(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.listeners.forEach(Runnable::run);
        this.listeners.clear();
        this.disconnect();
    }

    public void addCloseListener(@NotNull Runnable listener) {
        this.listeners.add(listener);
    }

    public boolean matchesParameters(@NotNull String host, int port) {
        return false;
    }

    @NotNull
    public DBWTunnel.AuthCredentials getRequiredCredentials(@NotNull DBWHandlerConfiguration configuration) {
        return DBWTunnel.AuthCredentials.NONE;
    }

    public Object getImplementation() {
        return this;
    }

    private void connect(@NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration info) throws DBException {
        SMSessionRemote session = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession());
        if (session == null) {
            throw new DBException("Remote session is not available");
        }
        DCUserConfigurationProvider configurationProvider = (DCUserConfigurationProvider)DBUtils.getAdapter(DCUserConfigurationProvider.class, (Object)session.getSessionSpace());
        if (configurationProvider == null) {
            throw new DBException("Remote user configuration is not available. Not a remote workspace?");
        }
        DCUserConfiguration userConfiguration = configurationProvider.getUserConfiguration();
        if (!userConfiguration.isFeatureEnabled(ID)) {
            throw new DBException("DBeaver Database Tunnel is not supported by the remote server");
        }
        UdbtEndpoint endpoint = new UdbtEndpoint(UdbtTunnel.createEndpointUri(userConfiguration), dataSourceContainer.getProject().getId(), dataSourceContainer.getId());
        try {
            this.transport = new UdbtWsTransport(endpoint, session.getRemoteCredentialsProvider());
        }
        catch (Exception e) {
            throw new DBException("Failed to establish tunnel", (Throwable)e);
        }
        info.setHostName(TUNNEL_LOCAL_HOST);
        info.setHostPort(String.valueOf(this.transport.getLocalPort()));
        info.setUrl(dataSourceContainer.getDriver().getConnectionURL(info));
    }

    private void disconnect() throws DBException {
        if (this.transport != null) {
            try {
                this.transport.close();
                this.transport = null;
            }
            catch (Exception e) {
                throw new DBException("Failed to close WebSocket connection", (Throwable)e);
            }
        }
    }

    @NotNull
    private static URI createEndpointUri(@NotNull DCUserConfiguration config) throws DBException {
        String endpoint = config.getServiceEndpoint(MSServiceType.CLOUDBEAVER);
        if (endpoint == null) {
            throw new DBException(String.valueOf(MSServiceType.CLOUDBEAVER) + " service endpoint is not available");
        }
        return URI.create(endpoint.replaceFirst("^http?", "ws") + "/api/ws/udbt");
    }
}

