/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListMFADeviceTagsIterable
implements SdkIterable<ListMfaDeviceTagsResponse> {
    private final IamClient client;
    private final ListMfaDeviceTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMFADeviceTagsIterable(IamClient client, ListMfaDeviceTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMfaDeviceTagsResponseFetcher();
    }

    public Iterator<ListMfaDeviceTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListMfaDeviceTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMfaDeviceTagsResponseFetcher
    implements SyncPageFetcher<ListMfaDeviceTagsResponse> {
        private ListMfaDeviceTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListMfaDeviceTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListMfaDeviceTagsResponse nextPage(ListMfaDeviceTagsResponse previousPage) {
            if (previousPage == null) {
                return ListMFADeviceTagsIterable.this.client.listMFADeviceTags(ListMFADeviceTagsIterable.this.firstRequest);
            }
            return ListMFADeviceTagsIterable.this.client.listMFADeviceTags((ListMfaDeviceTagsRequest)((Object)ListMFADeviceTagsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

