/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;

public class ListAttachedRolePoliciesIterable
implements SdkIterable<ListAttachedRolePoliciesResponse> {
    private final IamClient client;
    private final ListAttachedRolePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedRolePoliciesIterable(IamClient client, ListAttachedRolePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttachedRolePoliciesResponseFetcher();
    }

    public Iterator<ListAttachedRolePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedRolePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachedRolePoliciesResponseFetcher
    implements SyncPageFetcher<ListAttachedRolePoliciesResponse> {
        private ListAttachedRolePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedRolePoliciesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public ListAttachedRolePoliciesResponse nextPage(ListAttachedRolePoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedRolePoliciesIterable.this.client.listAttachedRolePolicies(ListAttachedRolePoliciesIterable.this.firstRequest);
            }
            return ListAttachedRolePoliciesIterable.this.client.listAttachedRolePolicies((ListAttachedRolePoliciesRequest)((Object)ListAttachedRolePoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

