/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.oauth;

import com.dbeaver.jdbc.salesforce.oauth.IdentityResponseDTO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;

public class ServiceHandler {
    @NotNull
    public static Map<String, String> processResponseAndGetServiceData(HttpResponse<String> response, int timeout, Gson gson) throws IOException {
        JsonObject jsonObject = JsonParser.parseString((String)response.body()).getAsJsonObject();
        String accessToken = jsonObject.get("access_token").getAsString();
        if (accessToken != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("token", accessToken);
            String id = jsonObject.get("id").getAsString();
            if (id != null) {
                HttpClient client = HttpClient.newBuilder().cookieHandler(new CookieManager()).version(HttpClient.Version.HTTP_2).build();
                HttpResponse<String> serviceRequest = null;
                try {
                    serviceRequest = ServiceHandler.sendServiceRequest(id, client, accessToken, timeout);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                if (serviceRequest.statusCode() != 200) {
                    throw new IOException("Error getting service info " + response.statusCode());
                }
                String serviceResponse = serviceRequest.body();
                IdentityResponseDTO identityResponseDTO = (IdentityResponseDTO)gson.fromJson(serviceResponse, IdentityResponseDTO.class);
                if (identityResponseDTO.urls().partner() != null) {
                    result.put("service_endpoint", identityResponseDTO.urls().partner().replace("{version}", "58.0"));
                }
            }
            return result;
        }
        throw new IOException("Error extracting token");
    }

    private static HttpResponse<String> sendServiceRequest(String id, HttpClient client, String token, int timeout) throws IOException, InterruptedException {
        HttpRequest idRequest = HttpRequest.newBuilder().uri(URI.create(id)).setHeader("Authorization", "Bearer " + token).GET().timeout(Duration.ofSeconds(timeout)).build();
        return client.send(idRequest, HttpResponse.BodyHandlers.ofString());
    }
}

