/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.salesforce.oauth;

import com.dbeaver.jdbc.salesforce.oauth.ServiceHandler;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.oauth.code.OAuthCodeHandler;
import org.jkiss.utils.oauth.code.OAuthRequestURLBuilder;

public class SalesforceOAuthCodeHandler
extends OAuthCodeHandler {
    public SalesforceOAuthCodeHandler(@NotNull String clientId, @Nullable String secretId, @NotNull String authUrl, @NotNull String tokenURL, int callbackPort) {
        super(clientId, secretId, authUrl, tokenURL, callbackPort);
    }

    @NotNull
    protected Map<String, String> extractResponse(HttpResponse<String> response) throws IOException {
        return ServiceHandler.processResponseAndGetServiceData(response, this.timeout, gson);
    }

    private static HttpResponse<String> sendServiceRequest(String id, HttpClient client, String token, int timeout) throws IOException, InterruptedException {
        HttpRequest idRequest = HttpRequest.newBuilder().uri(URI.create(id)).setHeader("Authorization", "Bearer " + token).GET().timeout(Duration.ofSeconds(timeout)).build();
        return client.send(idRequest, HttpResponse.BodyHandlers.ofString());
    }

    protected String buildAuthUrl() throws IOException {
        return new OAuthRequestURLBuilder(this.authUrl).withClientId(this.clientId).withRedirectURI(String.format("http://localhost:%s%s", this.callbackPort, this.callbackEndpoint)).withCodeChallenge(this.codeChallenge).disableDefaultScope().withParam("display", "popup").withPrompt("select_account").build();
    }
}

