/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.navigator;

import com.dbeaver.model.tableau.TBIcon;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.navigator.DBNTableauAbstractNode;
import com.dbeaver.model.tableau.navigator.DBNTableauRootNode;
import com.dbeaver.model.tableau.navigator.DBNTableauSiteNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNTableauProfileNode
extends DBNTableauAbstractNode
implements DBNObjectNode {
    private static final Log log = Log.getLog(DBNTableauProfileNode.class);
    private final TBAuthProfile profile;
    private TBSession session;
    private DBNTableauSiteNode[] sites;

    DBNTableauProfileNode(DBNTableauRootNode parentNode, TBAuthProfile profile) {
        super(parentNode);
        this.profile = profile;
    }

    public TBAuthProfile getProfile() {
        return this.profile;
    }

    public TBSession getSession() {
        return this.session;
    }

    @NotNull
    public String getNodeType() {
        return "Tableau profile";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.profile.getName();
    }

    @Nullable
    public String getNodeDescription() {
        return "Tableau profile";
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return TBIcon.TABLEAU;
    }

    protected boolean allowsChildren() {
        return true;
    }

    @Nullable
    public DBNTableauSiteNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sites == null && !monitor.isForceCacheUsage()) {
            this.checkSession(monitor);
            this.sites = (DBNTableauSiteNode[])this.session.getSites(monitor).stream().map(s -> new DBNTableauSiteNode(this, (TBSite)s)).toArray(DBNTableauSiteNode[]::new);
        }
        return this.sites;
    }

    private void checkSession(DBRProgressMonitor monitor) throws DBException {
        if (this.session != null) {
            return;
        }
        monitor.beginTask("Open Tableau session", 1);
        try {
            this.session = this.profile.getSession(monitor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean needsInitialization() {
        return this.sites == null;
    }

    public TBAuthProfile getNodeObject() {
        return this.profile;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.sites = null;
        this.session = null;
        this.profile.resetSession();
        return super.refreshNode(monitor, source);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getNodeDisplayName();
    }
}

