/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.db2.zos;

import com.dbeaver.db.db2.zos.DB2ZOSTableColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.zos.model.DB2ZOSMetaModel;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class DB2ZOSMetaModelTest
extends DB2ZOSMetaModel {
    private static final Log log = Log.getLog(DB2ZOSMetaModelTest.class);

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase table) throws SQLException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("SELECT * ");
        ddl.append("FROM SYSIBM.SYSCOLUMNS ");
        ddl.append("WHERE TBCREATOR=? ");
        if (table != null) {
            ddl.append("AND TBNAME=? ");
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(ddl.toString());
        dbStat.setString(1, owner.getName());
        if (table != null) {
            dbStat.setString(2, table.getName());
        }
        return dbStat;
    }

    @NotNull
    public JDBCStatement prepareForeignKeysLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase table) throws SQLException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("SELECT * ");
        ddl.append("FROM SYSIBM.SYSTABCONST ");
        ddl.append("WHERE TBCREATOR=? ");
        if (table != null) {
            ddl.append("AND TBNAME=? ");
        }
        ddl.append("AND TYPE='F' ");
        JDBCPreparedStatement dbStat = session.prepareStatement(ddl.toString());
        dbStat.setString(1, owner.getName());
        if (table != null) {
            dbStat.setString(2, table.getName());
        }
        return dbStat;
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, GenericTableBase table) throws SQLException, DBException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("SELECT * ");
        ddl.append("FROM SYSIBM.SYSTABCONST ");
        ddl.append("WHERE TBCREATOR=? ");
        if (table != null) {
            ddl.append("AND TBNAME=? ");
        }
        ddl.append("AND TYPE <> 'F'");
        JDBCPreparedStatement dbStat = session.prepareStatement(ddl.toString());
        dbStat.setString(1, owner.getName());
        if (table != null) {
            dbStat.setString(2, table.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(@NotNull JDBCResultSet dbResult) {
        String constraintType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE");
        if ("U".equals(constraintType)) {
            return DBSEntityConstraintType.UNIQUE_KEY;
        }
        if ("P".equals(constraintType)) {
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        return DBSEntityConstraintType.CHECK;
    }

    public boolean supportsUniqueKeys() {
        return true;
    }

    public DB2ZOSTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) {
        if (dbResult != null) {
            try {
                ordinalPos = dbResult.getInt("COLNO");
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new DB2ZOSTableColumn(monitor, dbResult, table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }
}

