/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data.gis;

import java.util.AbstractList;

public class SDOOrdinateList
extends AbstractList {
    final double[] ARRAY;
    final int OFFSET;
    final int LEN;
    final int SIZE;
    final int START;
    final int END;
    final int STEP;

    public SDOOrdinateList(double[] array) {
        this(array, 0, 1);
    }

    public SDOOrdinateList(double[] array, int offset, int len) {
        this(array, offset, len, 0, array.length);
    }

    public SDOOrdinateList(double[] array, int offset, int len, int start, int end) {
        this.START = start;
        this.END = end;
        this.ARRAY = array;
        this.OFFSET = offset;
        this.LEN = len;
        this.SIZE = Math.abs(this.START - this.END) / this.LEN;
        int n = this.STEP = this.START < this.END ? this.LEN : -this.LEN;
        if (this.ARRAY.length % this.LEN != 0) {
            throw new IllegalArgumentException("You have requested SDOCoordinates of " + this.LEN + " ordinates. This is inconsistent with an array of length " + this.ARRAY.length);
        }
    }

    @Override
    public Object get(int index) {
        return new Double(this.getDouble(index));
    }

    public double getDouble(int index) {
        assert (index < this.SIZE) : "Index: " + index + ", Size: " + this.SIZE;
        return this.ARRAY[this.START + this.STEP * index + this.OFFSET];
    }

    public double[] toDoubleArray() {
        double[] array = new double[this.size()];
        int i = 0;
        while (i < this.size()) {
            array[i] = this.getDouble(i);
            ++i;
        }
        return array;
    }

    @Override
    public int size() {
        return this.SIZE;
    }
}

