/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.engine.anthropic;

import com.dbeaver.model.ai.engine.anthropic.AnthropicCompletionEngine;
import com.dbeaver.model.ai.engine.anthropic.AnthropicModels;
import com.dbeaver.model.ai.engine.anthropic.AnthropicProperties;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.ai.model.CachedValue;
import org.jkiss.dbeaver.ui.ai.model.ContextWindowSizeField;
import org.jkiss.dbeaver.ui.ai.model.ModelSelectorField;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;

public class AnthropicConfigurator
implements AIIObjectPropertyConfigurator<AIEngineDescriptor, AnthropicProperties> {
    private ModelSelectorField modelSelectorField;
    private Text temperatureText;
    private String temperature;
    private Text tokenText;
    private String token;
    protected final CachedValue<List<AIModel>> modelsCache = new CachedValue(this::fetchAnthropicModels);
    private Button logQueryCheck;
    private boolean logQuery;
    private ContextWindowSizeField contextWindowSizeField;

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)3);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
    }

    public void loadSettings(@NotNull AnthropicProperties configuration) {
        this.token = CommonUtils.toString((Object)configuration.getToken());
        this.modelSelectorField.setSelectedModel(CommonUtils.toString((Object)configuration.getModel(), (String)"claude-opus-4-1-20250805"));
        this.temperature = CommonUtils.toString((Object)configuration.getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)configuration.isLoggingEnabled());
        this.applySettings();
        this.contextWindowSizeField.setValue(configuration.getContextWindowSize());
        this.modelSelectorField.refreshModelListSilently(false);
    }

    public void saveSettings(@NotNull AnthropicProperties configuration) {
        configuration.setToken(this.token);
        configuration.setModel(this.modelSelectorField.getSelectedModel());
        configuration.setContextWindowSize(this.contextWindowSizeField.getValue());
        configuration.setTemperature(CommonUtils.toDouble((Object)this.temperature));
        configuration.setLoggingEnabled(this.logQuery);
    }

    public void resetSettings(@NotNull AnthropicProperties anthropicPropertiesLegacyAISettings) {
    }

    public boolean isComplete() {
        return this.tokenText != null && !this.tokenText.getText().isEmpty() && this.contextWindowSizeField.isComplete();
    }

    public Optional<AIEngineProperties> getCurrentProperties() {
        AnthropicProperties properties = new AnthropicProperties();
        this.saveSettings(properties);
        return Optional.of(properties);
    }

    protected void createURLInfoLink(@NotNull Composite parent) {
        Link link = UIUtils.createLink((Composite)parent, (String)NLS.bind((String)AIUIMessages.gpt_preference_page_token_info, (Object)this.getApiKeyURL()), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.openWebBrowser((String)AnthropicConfigurator.this.getApiKeyURL());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        link.setLayoutData((Object)gd);
    }

    protected String getApiKeyURL() {
        return "https://console.anthropic.com/dashboard";
    }

    protected void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write AI queries to debug log", (String)"Write AI queries with metadata info in debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnthropicConfigurator.this.logQuery = AnthropicConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    private void createConnectionParameters(Composite parent) {
        this.tokenText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.tokenText.setLayoutData((Object)gd);
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage("API access token");
        this.createURLInfoLink(parent);
    }

    private void createModelParameters(@NotNull Composite parent) {
        this.modelSelectorField = ModelSelectorField.builder().withParent(parent).withGridData(new GridData(768)).withModelListSupplier((monitor, forceRefresh) -> ((List)this.modelsCache.get(monitor, forceRefresh)).stream().filter(it -> it.features().contains(AIModelFeature.CHAT)).map(AIModel::name).toList()).withSelectionListener(SelectionListener.widgetSelectedAdapter(e -> AnthropicModels.getModelByName((String)this.modelSelectorField.getSelectedModel()).ifPresentOrElse(model -> {
            this.contextWindowSizeField.setValue(model.contextWindowSize());
            this.temperatureText.setText(String.valueOf(model.defaultTemperature()));
        }, () -> {
            this.contextWindowSizeField.setValue(null);
            this.temperatureText.setText("0.0");
        }))).build();
        this.contextWindowSizeField = ContextWindowSizeField.builder().withParent(parent).withGridData(GridDataFactory.fillDefaults().span(2, 1).create()).build();
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.temperatureText.setToolTipText("Lower temperatures give more precise results");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
    }

    private void applySettings() {
        if (this.tokenText != null) {
            this.tokenText.setText(this.token);
        }
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
    }

    private List<AIModel> fetchAnthropicModels(DBRProgressMonitor monitor) throws DBException {
        if (this.token == null || this.token.isEmpty()) {
            throw new DBException("Token is not set");
        }
        AnthropicProperties properties = new AnthropicProperties();
        properties.setToken(this.token);
        Throwable throwable = null;
        Object var4_5 = null;
        try (AnthropicCompletionEngine engine = new AnthropicCompletionEngine(properties);){
            return engine.getModels(monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

