/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.commands;

import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import com.dbeaver.ui.ai.resultset.ExplainErrorAction;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIIcons;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class ExplainWithAIMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final Log log = Log.getLog(ExplainWithAIMarkerResolutionGenerator.class);
    private static final IMarkerResolution[] resolutions = new IMarkerResolution[]{new MarkerResolution()};

    public boolean hasResolutions(@NotNull IMarker marker) {
        return SQLEditorUtils.isProblemMarker((IMarker)marker) && CommonUtils.isNotEmpty((String)marker.getAttribute("message", ""));
    }

    public IMarkerResolution[] getResolutions(@NotNull IMarker marker) {
        return resolutions;
    }

    @Nullable
    private static SQLEditorWithMarkerPosition findSuitableSqlEditor(@NotNull IMarker marker) {
        SQLEditor sqlEditor;
        Integer offset;
        IEditorPart activeEditor;
        IResource editorResource;
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (editorResource = ResourceUtil.getResource((IEditorInput)(activeEditor = page.getActiveEditor()).getEditorInput())) != null && editorResource.equals((Object)marker.getResource()) && activeEditor instanceof SQLEditor && (offset = ExplainWithAIMarkerResolutionGenerator.obtainMarkerOffset(sqlEditor = (SQLEditor)activeEditor, marker)) != null) {
            return new SQLEditorWithMarkerPosition(page, sqlEditor, offset);
        }
        SQLEditorUtils.EditorsCollection resourceEditors = SQLEditorUtils.findResourceEditors((IResource)marker.getResource());
        if (resourceEditors != null && !resourceEditors.isEmpty()) {
            Pair connectedEditor;
            Integer offset2;
            Pair connectedEditor2;
            List connectedEditors = resourceEditors.findConnectedSqlEditors();
            if (!connectedEditors.isEmpty() && (offset = ExplainWithAIMarkerResolutionGenerator.obtainMarkerOffset((SQLEditor)(connectedEditor2 = (Pair)connectedEditors.getFirst()).getSecond(), marker)) != null) {
                return new SQLEditorWithMarkerPosition((IWorkbenchPage)connectedEditor2.getFirst(), (SQLEditor)connectedEditor2.getSecond(), offset);
            }
            List disconnectedEditors = resourceEditors.findNotConnectedSqlEditors();
            if (!disconnectedEditors.isEmpty() && (offset2 = ExplainWithAIMarkerResolutionGenerator.obtainMarkerOffset((SQLEditor)(connectedEditor = (Pair)connectedEditors.getFirst()).getSecond(), marker)) != null) {
                return new SQLEditorWithMarkerPosition((IWorkbenchPage)connectedEditor.getFirst(), (SQLEditor)connectedEditor.getSecond(), offset2);
            }
        }
        return null;
    }

    @Nullable
    private static Integer obtainMarkerOffset(@NotNull SQLEditor editor, @NotNull IMarker marker) {
        try {
            int charStart;
            if (editor.getViewer() != null) {
                IAnnotationModel annotationModel = editor.getViewer().getAnnotationModel();
                Iterator ai = annotationModel.getAnnotationIterator();
                while (ai.hasNext()) {
                    Position annoPosition;
                    MarkerAnnotation markerAnnotation;
                    Annotation annotation = (Annotation)ai.next();
                    if (annotation.isMarkedDeleted() || !(annotation instanceof MarkerAnnotation) || !marker.equals((Object)(markerAnnotation = (MarkerAnnotation)annotation).getMarker()) || (annoPosition = annotationModel.getPosition(annotation)) == null) continue;
                    return annoPosition.getOffset();
                }
            }
            if ((charStart = MarkerUtilities.getCharStart((IMarker)marker)) >= 0) {
                return charStart;
            }
            int lineNumber = MarkerUtilities.getLineNumber((IMarker)marker);
            if (lineNumber >= 0 && editor.getDocument() != null) {
                return editor.getDocument().getLineOffset(lineNumber);
            }
            return null;
        }
        catch (BadLocationException e) {
            log.error((Object)e);
            return null;
        }
    }

    private static class MarkerResolution
    implements IMarkerResolution2 {
        public String getDescription() {
            return AIUIAdvancedMessages.ai_explain_and_fix_description;
        }

        public Image getImage() {
            return DBeaverIcons.getImage((DBPImage)AIIcons.AI);
        }

        public String getLabel() {
            return AIUIAdvancedMessages.ai_explain_and_fix_marker_resolution_label;
        }

        public void run(@NotNull IMarker marker) {
            SQLEditorWithMarkerPosition editorAndOffset = ExplainWithAIMarkerResolutionGenerator.findSuitableSqlEditor(marker);
            if (editorAndOffset != null) {
                String errorMessage = marker.getAttribute("message", "");
                ExtendedMarkersView.openMarkerInEditor((IMarker)marker, (IWorkbenchPage)editorAndOffset.workbenchPage);
                ExplainErrorAction.openAiExplainAndFixChat(editorAndOffset.editor, editorAndOffset.offset, errorMessage);
            } else {
                DBWorkbench.getPlatformUI().showError("Explain and Fix", "Failed to find suitable editor context to connect with AI.Please try go to the problem location and ask for Explain and Fix again.");
            }
        }
    }

    private record SQLEditorWithMarkerPosition(@NotNull IWorkbenchPage workbenchPage, @NotNull SQLEditor editor, int offset) {
    }
}

