/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.commands;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;

public class AIPropertyTester
extends PropertyTester {
    public static final String CAN_DESCRIBE_OBJECT = "canDescribeObject";
    public static final String ENABLE_AI_SUGGESTION = "enableAiSuggestion";
    public static final String IS_ENTITY_EDITOR = "isEntityEditor";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (AISettingsManager.getInstance().getSettings().isAiDisabled()) {
            return false;
        }
        return switch (property) {
            case CAN_DESCRIBE_OBJECT -> AIPropertyTester.isObjectEditable(receiver);
            case ENABLE_AI_SUGGESTION -> DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.enableSuggestion");
            case IS_ENTITY_EDITOR -> AIPropertyTester.isEntityEditor();
            default -> false;
        };
    }

    private static boolean isObjectEditable(Object receiver) {
        IStructuredSelection selection;
        if (receiver instanceof IStructuredSelection && !(selection = (IStructuredSelection)receiver).isEmpty()) {
            Object firstElement = selection.getFirstElement();
            DBSObject dbObject = null;
            if (firstElement instanceof DBNDatabaseNode) {
                DBNDatabaseNode element = (DBNDatabaseNode)firstElement;
                dbObject = element.getObject();
            } else if (firstElement instanceof DBSObject) {
                DBSObject element;
                dbObject = element = (DBSObject)firstElement;
            }
            return AIUtils.isEligible(dbObject);
        }
        return false;
    }

    private static boolean isEntityEditor() {
        return UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof EntityEditor;
    }
}

