/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.commands;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.prompt.AIPromptExplainSqlQuery;
import com.dbeaver.ui.ai.chat.AIChatView;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIProFeatures;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.StringUtils;

public class AIExplainQueryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        AIChatControl chat;
        SQLEditor editor = (SQLEditor)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class);
        if (editor == null) {
            return null;
        }
        SQLScriptElement query = editor.extractActiveQuery();
        if (query == null) {
            return null;
        }
        DBPDataSourceContainer ds = editor.getDataSourceContainer();
        try {
            chat = AIChatView.show().getChat();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Explain Query", "Can't open AI chat", (Throwable)e);
            return null;
        }
        if (ds != null) {
            AIProFeatures.AI_EXPLAIN_SQL.use(AIProFeatures.buildFeatureParameters(ds));
        }
        try {
            AIChatConversation conversation = chat.findOrCreateAssociatedConversation(editor, query, new AIChatConversation("Explain query '" + StringUtils.truncateToSpace((String)query.getText(), (int)40) + "'", (AIPromptGenerator)AIPromptExplainSqlQuery.create(() -> ds == null ? null : new DBSLogicalDataSource(ds)), List.of(), ds));
            chat.selectConversation(conversation);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Explain Query", "Can't create/use AI chat conversation", (Throwable)e);
            return null;
        }
        chat.submitPrompt(AIPromptExplainSqlQuery.createExplainQueryMessage((String)query.getText()));
        return null;
    }
}

