/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.ui.ai.chat.AIChatUtils;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIIcons;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.CompositeBorderPainter;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.DisabledLabelAction;
import org.jkiss.dbeaver.ui.ai.AIUIUtils;
import org.jkiss.utils.ArrayUtils;

public class ContextComposite
extends Composite {
    private static final Log log = Log.getLog(ContextComposite.class);
    private static final String CSS_ID = "ai-chat-context";
    private final AIChatControl chat;
    private final Composite contextComposite;
    private final Label contextIcon;
    private final Label contextName;
    private final MenuManager scopeDropDown;
    private final MenuManager contextDropDown;
    private final MenuManager conversationDropDown;
    private final ToolBarManager toolBarManager;
    private final Composite conversationComposite;
    private final Label conversationIcon;
    private final Text conversationNameText;
    private final List<AIChatConversation> contextConversations = new ArrayList<AIChatConversation>();
    private IAction changeScopeAction;
    private IAction addConversationAction;
    private IAction deleteConversationAction;

    public ContextComposite(final @NotNull AIChatControl chat, @NotNull Composite parent) {
        super(parent, 0);
        this.chat = chat;
        this.chat.getChatSession().addListener(new AIChatListener(){

            public void messageAdded(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
                ContextComposite.this.updateActions();
                ContextComposite.this.conversationNameText.setText(conversation.getCaption());
                chat.renameConversation(conversation, conversation.getCaption());
            }

            public void messageRemoved(@NotNull AIChatConversation conversation, @NotNull AIChatMessage message) {
                ContextComposite.this.updateActions();
            }

            public void settingsChanged(@Nullable AIContextSettings settings) {
                ContextComposite.this.updateContext(settings);
            }

            public void conversationChanged(@NotNull AIChatConversation conversation) {
                try {
                    ContextComposite.this.updateConversation(conversation);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error updating conversation list", "Can't update conversation list", (Throwable)e);
                }
            }

            public void busyChanged(boolean busy) {
                ContextComposite.this.updateActions();
                UIUtils.enableWithChildren((Control)ContextComposite.this.contextComposite, (!busy ? 1 : 0) != 0);
                UIUtils.enableWithChildren((Control)ContextComposite.this.conversationComposite, (!busy ? 1 : 0) != 0);
            }
        });
        this.setLayout((Layout)new GridLayout(2, false));
        WidgetElement.setID((Widget)this, (String)CSS_ID);
        this.contextComposite = new Composite((Composite)this, 0);
        this.contextComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 2).numColumns(3).create());
        GridData gd = new GridData(4, 1, true, false);
        this.contextComposite.setLayoutData((Object)gd);
        new CompositeBorderPainter((Control)this.contextComposite);
        this.contextIcon = new Label(this.contextComposite, 0);
        this.contextIcon.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
        this.contextName = new Label(this.contextComposite, 0);
        this.contextName.setLayoutData((Object)new GridData(4, 1, true, false));
        this.contextName.addMouseListener(MouseListener.mouseDownAdapter(e -> this.showContextDropDown()));
        Label contextArrow = new Label(this.contextComposite, 0);
        contextArrow.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TREE_COLLAPSE));
        contextArrow.addMouseListener(MouseListener.mouseDownAdapter(e -> this.showContextDropDown()));
        this.contextDropDown = new MenuManager();
        this.contextDropDown.setRemoveAllWhenShown(true);
        this.contextDropDown.addMenuListener(manager -> {
            try {
                this.fillContextDropDown(manager);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error filling context drop-down", "Can't fill context drop-down", (Throwable)e);
            }
        });
        this.toolBarManager = new ToolBarManager(0x800000);
        this.contributeContextActions((IContributionManager)this.toolBarManager);
        this.toolBarManager.createControl((Composite)this);
        this.scopeDropDown = new MenuManager();
        this.scopeDropDown.setRemoveAllWhenShown(true);
        this.scopeDropDown.addMenuListener(this::fillScopeDropDown);
        this.conversationComposite = new Composite((Composite)this, 128);
        this.conversationComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 2).numColumns(3).create());
        this.conversationComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        new CompositeBorderPainter((Control)this.conversationComposite);
        this.conversationIcon = new Label(this.conversationComposite, 0);
        this.conversationIcon.setImage(DBeaverIcons.getImage((DBPImage)AIIcons.AI));
        this.conversationNameText = new Text(this.conversationComposite, 0);
        this.conversationNameText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.conversationNameText.addMouseListener(MouseListener.mouseDoubleClickAdapter(mouseEvent -> this.showConversationDropDown()));
        this.conversationNameText.addFocusListener(FocusListener.focusLostAdapter(e -> {
            AIChatConversation activeConversation = chat.getActiveConversation();
            chat.renameConversation(activeConversation, this.conversationNameText.getText());
        }));
        Label conversationArrow = new Label(this.conversationComposite, 0);
        conversationArrow.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TREE_COLLAPSE));
        conversationArrow.addMouseListener(MouseListener.mouseDownAdapter(e -> this.showConversationDropDown()));
        this.conversationDropDown = new MenuManager();
        this.conversationDropDown.setRemoveAllWhenShown(true);
        this.conversationDropDown.addMenuListener(this::fillConversationDropDown);
        ToolBarManager conversationToolBarManager = new ToolBarManager(0x800000);
        this.contributeConversationActions((IContributionManager)conversationToolBarManager);
        conversationToolBarManager.createControl((Composite)this);
        this.updateContext(null);
    }

    public void dispose() {
        super.dispose();
        this.toolBarManager.dispose();
        this.contextDropDown.dispose();
        this.scopeDropDown.dispose();
    }

    private void updateContext(@Nullable AIContextSettings completionSettings) {
        if (completionSettings != null) {
            this.contextName.setText(completionSettings.getDataSourceContainer().getName());
            this.contextIcon.setImage(DBeaverIcons.getImage((DBPImage)completionSettings.getDataSourceContainer().getDriver().getIcon()));
        } else {
            this.contextName.setText("No connection");
            this.contextIcon.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.DATABASE_DEFAULT));
        }
        this.updateActions();
    }

    private AIChatConversation findConversation(@NotNull String name) {
        for (AIChatConversation conversation : this.contextConversations) {
            if (!conversation.getCaption().equals(name)) continue;
            return conversation;
        }
        return null;
    }

    private void updateConversation(@NotNull AIChatConversation conversation) throws DBException {
        this.contextConversations.clear();
        this.contextConversations.addAll(this.chat.listConversations());
        DBPImage convIcon = ContextComposite.getConversationIcon(conversation);
        this.conversationIcon.setImage(DBeaverIcons.getImage((DBPImage)convIcon));
        this.conversationNameText.setText(conversation.getCaption());
    }

    private static DBPImage getConversationIcon(@NotNull AIChatConversation conversation) {
        DBIcon convIcon = AIIcons.AI;
        AIPromptGenerator promptGenerator = conversation.getPromptGenerator();
        AIPromptGeneratorDescriptor gd = AIPromptGeneratorRegistry.getInstance().getPromptGenerator(promptGenerator.generatorId());
        if (gd != null && gd.getIcon() != null) {
            convIcon = gd.getIcon();
        }
        return convIcon;
    }

    private void showContextDropDown() {
        Control[] ccc = this.contextComposite.getChildren();
        this.showDropDown(ccc[ccc.length - 1], 0, this.contextDropDown);
    }

    private void showConversationDropDown() {
        Control[] ccc = this.conversationComposite.getChildren();
        this.showDropDown(ccc[ccc.length - 1], 0, this.conversationDropDown);
    }

    private void showScopeDropDown() {
        ToolBar toolBar = this.toolBarManager.getControl();
        this.showDropDown((Control)toolBar, toolBar.getItem((int)0).getBounds().width / 2, this.scopeDropDown);
    }

    private void showDropDown(@NotNull Control origin, int shift, @NotNull MenuManager manager) {
        Menu menu = manager.createContextMenu(origin);
        menu.setLocation(origin.toDisplay(shift, origin.getSize().y));
        menu.setVisible(true);
    }

    private void fillContextDropDown(@NotNull IMenuManager manager) throws DBException {
        List projects = DBWorkbench.getPlatform().getWorkspace().getProjects();
        LinkedHashSet<DBPDataSourceContainer> containers = new LinkedHashSet<DBPDataSourceContainer>(this.chat.getChatSession().getAllDataSources());
        containers.addAll(projects.stream().filter(DBPProject::isRegistryLoaded).map(DBPProject::getDataSourceRegistry).flatMap(ds -> ds.getDataSources().stream()).filter(DBPDataSourceContainer::isConnected).toList());
        if (containers.isEmpty()) {
            manager.add((IAction)new EmptyAction("No active connections"));
        }
        for (final DBPDataSourceContainer container : containers) {
            manager.add((IAction)new Action(container.getName(), DBeaverIcons.getImageDescriptor((DBPImage)container.getDriver().getIcon())){

                public void run() {
                    try {
                        ContextComposite.this.chat.setDataSource(container);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error setting data source", "Could not set data source: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        if (this.chat.getCompletionSettings() != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action("No connection", DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.DATABASE_DEFAULT)){

                public void run() {
                    try {
                        ContextComposite.this.chat.setDataSource(null);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error clearing data source", "Could not clear data source: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void fillConversationDropDown(@NotNull IMenuManager manager) {
        for (final AIChatConversation conversion : this.contextConversations) {
            manager.add((IAction)new Action(conversion.getCaption(), DBeaverIcons.getImageDescriptor((DBPImage)ContextComposite.getConversationIcon(conversion))){

                public void run() {
                    try {
                        ContextComposite.this.chat.selectConversation(conversion);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error selecting conversation", "Could not select conversation: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void fillScopeDropDown(@NotNull IMenuManager manager) {
        DBCExecutionContext executionContext;
        AIContextSettings settings = this.chat.getCompletionSettings();
        if (settings == null) {
            return;
        }
        manager.add((IAction)new DisabledLabelAction("Configure AI context"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new DisabledLabelAction("Applies to"));
        manager.add((IAction)new ChangeContextLevelAction(true));
        manager.add((IAction)new ChangeContextLevelAction(false));
        manager.add((IContributionItem)new Separator());
        DBPDataSourceContainer dsContainer = this.chat.getDataSourceContainer();
        DBCExecutionContext dBCExecutionContext = executionContext = dsContainer == null ? null : this.chat.getExecutionContext(dsContainer);
        if (executionContext == null) {
            manager.add((IAction)new DisabledLabelAction(dsContainer == null ? "No database connection selected" : (dsContainer.isConnecting() ? "Database is being connected..." : "Database is not connected")));
            return;
        }
        manager.add((IAction)new DisabledLabelAction("Metadata sent to AI"));
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        boolean showSchemas = false;
        boolean showCatalogs = false;
        if (contextDefaults != null) {
            showSchemas = contextDefaults.getDefaultSchema() != null || contextDefaults.supportsSchemaChange();
            showCatalogs = contextDefaults.getDefaultCatalog() != null || contextDefaults.supportsCatalogChange();
        }
        AIDatabaseScope[] aIDatabaseScopeArray = AIDatabaseScope.values();
        int n = aIDatabaseScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AIDatabaseScope scope = aIDatabaseScopeArray[n2];
            if (scope == AIDatabaseScope.CURRENT_SCHEMA && !showSchemas || scope == AIDatabaseScope.CURRENT_DATABASE && !showCatalogs) {
                if (settings.getScope() == scope) {
                    AIDatabaseScope newScope = scope == AIDatabaseScope.CURRENT_SCHEMA ? AIDatabaseScope.CURRENT_DATABASE : AIDatabaseScope.CURRENT_DATASOURCE;
                    log.trace((Object)("AI scope fallback to " + String.valueOf(newScope)));
                    settings.setScope(newScope);
                }
            } else {
                manager.add((IAction)new ChangeScopeAction(settings, scope, dsContainer, contextDefaults));
            }
            ++n2;
        }
    }

    private void updateActions() {
        boolean busy = this.chat.isBusy();
        this.changeScopeAction.setEnabled(!busy && this.chat.getCompletionSettings() != null);
        this.addConversationAction.setEnabled(!busy);
        this.deleteConversationAction.setEnabled(!busy);
    }

    private void contributeContextActions(@NotNull IContributionManager manager) {
        this.changeScopeAction = new Action(AIChatMessages.ai_chat_change_scope_label, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER_CONFIG)){

            public void run() {
                ContextComposite.this.showScopeDropDown();
            }
        };
        manager.add(this.changeScopeAction);
        manager.add((IAction)new Action(AIChatMessages.ai_chat_settings_label, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION)){

            public void run() {
                AIUIUtils.showPreferences((Shell)ContextComposite.this.getShell());
            }
        });
    }

    private void contributeConversationActions(@NotNull IContributionManager manager) {
        this.addConversationAction = new Action("New conversation", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ADD)){

            public void run() {
                String name = ContextComposite.this.createNewConversationName();
                try {
                    ContextComposite.this.chat.selectConversation(ContextComposite.this.chat.createEmptyConversation(name, ContextComposite.this.chat.getDataSourceContainer()));
                    ContextComposite.this.chat.setFocusOnPrompt();
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Error creating conversation", "Could not create new conversation: " + e.getMessage(), (Throwable)e);
                }
            }
        };
        this.deleteConversationAction = new Action("Delete conversation", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE)){

            public void run() {
                if (DBWorkbench.getPlatformUI().confirmAction("Delete conversation", "Are you sure you want to delete conversation '" + ContextComposite.this.chat.getActiveConversation().getCaption() + "'?")) {
                    try {
                        ContextComposite.this.chat.removeActiveConversation();
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error deleting conversation", "Could not delete conversation: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        manager.add(this.addConversationAction);
        manager.add(this.deleteConversationAction);
    }

    private String createNewConversationName() {
        String baseName = AIChatMessages.ai_chat_default_conversation_name;
        Object name = baseName;
        int i = 1;
        while (this.findConversation((String)name) != null) {
            name = baseName + " " + i;
            ++i;
        }
        return name;
    }

    private class ChangeContextLevelAction
    extends Action {
        private final boolean dataSourceContext;

        public ChangeContextLevelAction(boolean dataSourceContext) {
            super(dataSourceContext ? "This connection" : "This conversation", 8);
            this.dataSourceContext = dataSourceContext;
            boolean isDataSourceSettings = ContextComposite.this.chat.getCompletionSettings() instanceof AICompletionSettings;
            this.setChecked(dataSourceContext == isDataSourceSettings);
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            DBPDataSourceContainer dataSourceContainer = ContextComposite.this.chat.getDataSourceContainer();
            if (dataSourceContainer == null) {
                DBWorkbench.getPlatformUI().showError("No connection", "Cannot change context level when no connection is selected");
                return;
            }
            AIContextSettings currentSettings = ContextComposite.this.chat.getChatSession().getConversationSettings(ContextComposite.this.chat.getActiveConversation());
            AIContextSettings newSettings = this.createContextSettings(dataSourceContainer, currentSettings);
            ContextComposite.this.chat.setCompletionSettings(newSettings);
        }

        @NotNull
        private AIContextSettings createContextSettings(@NotNull DBPDataSourceContainer dataSourceContainer, @Nullable AIContextSettings currentSettings) {
            Object newSettings = this.dataSourceContext ? new AICompletionSettings(dataSourceContainer) : new AIChatConversationSettings(ContextComposite.this.chat.getChatSession(), ContextComposite.this.chat.getActiveConversation());
            if (currentSettings != null && !this.dataSourceContext) {
                newSettings.setScope(currentSettings.getScope());
                if (newSettings.getScope() == AIDatabaseScope.CUSTOM) {
                    newSettings.setCustomObjectIds(currentSettings.getCustomObjectIds());
                }
            } else {
                newSettings.setScope(AIDatabaseScope.CURRENT_SCHEMA);
            }
            return newSettings;
        }
    }

    private class ChangeScopeAction
    extends Action {
        private final AIContextSettings settings;
        private final AIDatabaseScope scope;

        public ChangeScopeAction(@NotNull AIContextSettings settings, @NotNull AIDatabaseScope scope, @Nullable DBPDataSourceContainer dsContainer, DBCExecutionContextDefaults<?, ?> contextDefaults) {
            super(ChangeScopeAction.getScopeTitle(settings, scope, dsContainer, contextDefaults), 8);
            this.settings = settings;
            this.scope = scope;
            this.setChecked(settings.getScope() == scope);
        }

        private static String getScopeTitle(@NotNull AIContextSettings settings, @NotNull AIDatabaseScope scope, @NotNull DBPDataSourceContainer dsContainer, @Nullable DBCExecutionContextDefaults<?, ?> contextDefaults) {
            String title = scope.getTitle();
            return switch (scope) {
                case AIDatabaseScope.CURRENT_SCHEMA -> {
                    DBSSchema defaultSchema = contextDefaults == null ? null : contextDefaults.getDefaultSchema();
                    yield title + " (" + (defaultSchema == null ? "No schema selected" : DBUtils.getObjectFullName((DBPNamedObject)defaultSchema, (DBPEvaluationContext)DBPEvaluationContext.UI)) + ")";
                }
                case AIDatabaseScope.CURRENT_DATABASE -> {
                    DBSCatalog defaultDatabase = contextDefaults == null ? null : contextDefaults.getDefaultCatalog();
                    yield title + " (" + (defaultDatabase == null ? "No database selected" : DBUtils.getObjectFullName((DBPNamedObject)defaultDatabase, (DBPEvaluationContext)DBPEvaluationContext.UI)) + ")";
                }
                case AIDatabaseScope.CURRENT_DATASOURCE -> "All objects (" + dsContainer.getName() + ")";
                case AIDatabaseScope.CUSTOM -> title + " ..." + (String)(settings.getScope() == scope ? "(" + String.valueOf(ArrayUtils.isEmpty((Object[])settings.getCustomObjectIds()) ? "Empty" : Integer.valueOf(settings.getCustomObjectIds().length)) + ")" : "");
                default -> title;
            };
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            if (this.scope == AIDatabaseScope.CUSTOM) {
                this.chooseCustomScope();
            } else {
                this.settings.setScope(this.scope);
                AIChatUtils.saveContextSettings(ContextComposite.this.chat.getActiveConversation(), this.settings);
            }
        }

        private void chooseCustomScope() {
            DBPDataSourceContainer container = this.settings.getDataSourceContainer();
            AIChatUtils.chooseCustomScope(ContextComposite.this.getShell(), this.settings, container, ContextComposite.this.chat::getExecutionContext, ContextComposite.this.chat.getActiveConversation());
        }
    }
}

