/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;

public class WSEventHandlerDescriptor
extends AbstractDescriptor {
    private final AbstractDescriptor.ObjectType implType;
    @NotNull
    private final List<String> supportedTopics = new ArrayList<String>();

    protected WSEventHandlerDescriptor(IConfigurationElement contributorConfig) {
        super(contributorConfig);
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, contributorConfig, "class");
        IConfigurationElement[] iConfigurationElementArray = contributorConfig.getChildren("topic");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsElement = iConfigurationElementArray[n2];
            String dsId = dsElement.getAttribute("id");
            if (dsId != null) {
                this.supportedTopics.add(dsId);
            }
            ++n2;
        }
    }

    @NotNull
    public List<String> getSupportedTopics() {
        return this.supportedTopics;
    }

    @NotNull
    public WSEventHandler getInstance() {
        try {
            return (WSEventHandler)this.implType.createInstance(WSEventHandler.class);
        }
        catch (DBException e) {
            throw new IllegalStateException("Can not instantiate event handler '" + this.implType.getImplName() + "'", e);
        }
    }
}

