/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.gson;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class WSAbstractClassByIdDeserializer<T>
implements JsonDeserializer<T> {
    private static final String EVENT_ID_FIELD = "id";
    private final Gson gson = new Gson();
    private final Map<String, Class<? extends T>> eventClassById;

    public WSAbstractClassByIdDeserializer(Map<String, Class<? extends T>> eventClassById) {
        this.eventClassById = eventClassById;
    }

    public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement eventIdElement = jsonObject.get(EVENT_ID_FIELD);
        if (eventIdElement == null) {
            throw new JsonParseException("Event id not present: " + String.valueOf(jsonElement));
        }
        Class<? extends T> resultClass = this.eventClassById.get(eventIdElement.getAsString());
        if (resultClass == null) {
            throw new JsonParseException("Unknown event: " + String.valueOf(eventIdElement));
        }
        return (T)this.gson.fromJson(jsonElement, resultClass);
    }
}

