/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.websocket.event.WSClientEvent;
import org.jkiss.dbeaver.model.websocket.event.WSEvent;
import org.jkiss.dbeaver.model.websocket.gson.WSClientEventDeserializer;
import org.jkiss.dbeaver.model.websocket.gson.WSClientSideExclusionStrategy;
import org.jkiss.dbeaver.model.websocket.gson.WSEventDeserializer;

public class WSUtils {
    public static final Gson gson = WSUtils.baseGsonBuilder().create();
    public static final Gson clientGson = WSUtils.baseGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new WSClientSideExclusionStrategy()}).create();

    private static GsonBuilder baseGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(WSEvent.class, (Object)new WSEventDeserializer()).registerTypeAdapter(WSClientEvent.class, (Object)new WSClientEventDeserializer()).enableComplexMapKeySerialization();
    }

    public static URI convertUriToWS(@NotNull URI wsServerUri) {
        if (wsServerUri.getScheme().startsWith("ws")) {
            return wsServerUri;
        }
        String wsScheme = wsServerUri.getScheme().equals("https") ? "wss" : "ws";
        String wsEndpointLink = wsScheme + wsServerUri.toString().replaceFirst("^(http[s]?)", "");
        return URI.create(wsEndpointLink);
    }
}

