/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.disableconstraint;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.check.CheckAttribute;
import liquibase.ext.ora.disableconstraint.DisableConstraintStatement;
import liquibase.ext.ora.enableconstraint.EnableConstraintChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="disableConstraint", description="Disable constraint", priority=201)
public class DisableConstraintChange
extends CheckAttribute {
    @Override
    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        DisableConstraintStatement statement = new DisableConstraintStatement(schemaName, this.getTableName(), this.getConstraintName());
        statement.setTablespace(this.getTablespace());
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "constraint " + this.getConstraintName() + " DISABLED in " + this.getTableName();
    }

    protected Change[] createInverses() {
        EnableConstraintChange inverse = new EnableConstraintChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }
}

