/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.comment;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.ext.ora.comment.CommentOnStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="commentOn", description="Create or replace a comment on a table or a column", priority=201)
public class CommentOnChange
extends AbstractOracleChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String comment;

    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        CommentOnStatement statement = new CommentOnStatement(schemaName, this.getTableName(), this.getColumnName(), this.getComment());
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return this.columnName == null ? "Comment has been added to " + this.getTableName() : "Comment has been added to " + this.getTableName() + "." + this.getColumnName();
    }

    protected Change[] createInverses() {
        return new Change[0];
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

