/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.fluent.models.ServerUpdateParametersProperties;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ResourceIdentity;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.Sku;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;
import java.util.Map;

public final class ServerUpdateParameters
implements JsonSerializable<ServerUpdateParameters> {
    private ResourceIdentity identity;
    private Sku sku;
    private ServerUpdateParametersProperties innerProperties;
    private Map<String, String> tags;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerUpdateParameters withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServerUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ServerUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public ServerUpdateParameters withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerUpdateParameters withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerUpdateParameters withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.innerProperties() == null ? null : this.innerProperties().sslEnforcement();
    }

    public ServerUpdateParameters withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withSslEnforcement(sslEnforcement);
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ServerUpdateParameters withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ServerUpdateParameters withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public String replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerUpdateParameters withReplicationRole(String replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerUpdateParametersProperties();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ServerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ServerUpdateParameters)jsonReader.readObject(reader -> {
            ServerUpdateParameters deserializedServerUpdateParameters = new ServerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedServerUpdateParameters.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedServerUpdateParameters.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerUpdateParameters.innerProperties = ServerUpdateParametersProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedServerUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerUpdateParameters;
        });
    }
}

