/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.ResourceIdentity;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class ServerForCreate
implements JsonSerializable<ServerForCreate> {
    private ResourceIdentity identity;
    private Sku sku;
    private ServerPropertiesForCreate properties;
    private String location;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(ServerForCreate.class);

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerForCreate withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServerForCreate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public ServerPropertiesForCreate properties() {
        return this.properties;
    }

    public ServerForCreate withProperties(ServerPropertiesForCreate properties) {
        this.properties = properties;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ServerForCreate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ServerForCreate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model ServerForCreate"));
        }
        this.properties().validate();
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ServerForCreate"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ServerForCreate fromJson(JsonReader jsonReader) throws IOException {
        return (ServerForCreate)jsonReader.readObject(reader -> {
            ServerForCreate deserializedServerForCreate = new ServerForCreate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedServerForCreate.properties = ServerPropertiesForCreate.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServerForCreate.location = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedServerForCreate.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedServerForCreate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedServerForCreate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerForCreate;
        });
    }
}

