/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresql.fluent.models.ServerInner;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ResourceIdentity;
import com.azure.resourcemanager.postgresql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.ServerState;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.Sku;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface Server {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ResourceIdentity identity();

    public Sku sku();

    public String administratorLogin();

    public ServerVersion version();

    public SslEnforcementEnum sslEnforcement();

    public MinimalTlsVersionEnum minimalTlsVersion();

    public String byokEnforcement();

    public InfrastructureEncryption infrastructureEncryption();

    public ServerState userVisibleState();

    public String fullyQualifiedDomainName();

    public OffsetDateTime earliestRestoreDate();

    public StorageProfile storageProfile();

    public String replicationRole();

    public String masterServerId();

    public Integer replicaCapacity();

    public PublicNetworkAccessEnum publicNetworkAccess();

    public List<ServerPrivateEndpointConnection> privateEndpointConnections();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ServerInner innerModel();

    public Update update();

    public Server refresh();

    public Server refresh(Context var1);

    public void restart();

    public void restart(Context var1);

    public static interface UpdateStages {

        public static interface WithReplicationRole {
            public Update withReplicationRole(String var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccessEnum var1);
        }

        public static interface WithMinimalTlsVersion {
            public Update withMinimalTlsVersion(MinimalTlsVersionEnum var1);
        }

        public static interface WithSslEnforcement {
            public Update withSslEnforcement(SslEnforcementEnum var1);
        }

        public static interface WithVersion {
            public Update withVersion(ServerVersion var1);
        }

        public static interface WithAdministratorLoginPassword {
            public Update withAdministratorLoginPassword(String var1);
        }

        public static interface WithStorageProfile {
            public Update withStorageProfile(StorageProfile var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithStorageProfile,
    UpdateStages.WithAdministratorLoginPassword,
    UpdateStages.WithVersion,
    UpdateStages.WithSslEnforcement,
    UpdateStages.WithMinimalTlsVersion,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithReplicationRole {
        public Server apply();

        public Server apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithSku {
            public Server create();

            public Server create(Context var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(ServerPropertiesForCreate var1);
        }

        public static interface WithResourceGroup {
            public WithProperties withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithProperties,
    DefinitionStages.WithCreate {
    }
}

