/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;

public final class ServerUpdateParametersProperties
implements JsonSerializable<ServerUpdateParametersProperties> {
    private StorageProfile storageProfile;
    private String administratorLoginPassword;
    private ServerVersion version;
    private SslEnforcementEnum sslEnforcement;
    private MinimalTlsVersionEnum minimalTlsVersion;
    private PublicNetworkAccessEnum publicNetworkAccess;
    private String replicationRole;

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ServerUpdateParametersProperties withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerUpdateParametersProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerUpdateParametersProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.sslEnforcement;
    }

    public ServerUpdateParametersProperties withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        this.sslEnforcement = sslEnforcement;
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerUpdateParametersProperties withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerUpdateParametersProperties withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public String replicationRole() {
        return this.replicationRole;
    }

    public ServerUpdateParametersProperties withReplicationRole(String replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeStringField("sslEnforcement", this.sslEnforcement == null ? null : this.sslEnforcement.toString());
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("replicationRole", this.replicationRole);
        return jsonWriter.writeEndObject();
    }

    public static ServerUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerUpdateParametersProperties)jsonReader.readObject(reader -> {
            ServerUpdateParametersProperties deserializedServerUpdateParametersProperties = new ServerUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageProfile".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.storageProfile = StorageProfile.fromJson(reader);
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.version = ServerVersion.fromString(reader.getString());
                    continue;
                }
                if ("sslEnforcement".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.sslEnforcement = SslEnforcementEnum.fromString(reader.getString());
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.minimalTlsVersion = MinimalTlsVersionEnum.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.publicNetworkAccess = PublicNetworkAccessEnum.fromString(reader.getString());
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerUpdateParametersProperties.replicationRole = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerUpdateParametersProperties;
        });
    }
}

