/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.postgresql.models.ServerState;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ServerProperties
implements JsonSerializable<ServerProperties> {
    private String administratorLogin;
    private ServerVersion version;
    private SslEnforcementEnum sslEnforcement;
    private MinimalTlsVersionEnum minimalTlsVersion;
    private String byokEnforcement;
    private InfrastructureEncryption infrastructureEncryption;
    private ServerState userVisibleState;
    private String fullyQualifiedDomainName;
    private OffsetDateTime earliestRestoreDate;
    private StorageProfile storageProfile;
    private String replicationRole;
    private String masterServerId;
    private Integer replicaCapacity;
    private PublicNetworkAccessEnum publicNetworkAccess;
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.sslEnforcement;
    }

    public ServerProperties withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        this.sslEnforcement = sslEnforcement;
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerProperties withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public String byokEnforcement() {
        return this.byokEnforcement;
    }

    public InfrastructureEncryption infrastructureEncryption() {
        return this.infrastructureEncryption;
    }

    public ServerProperties withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        this.infrastructureEncryption = infrastructureEncryption;
        return this;
    }

    public ServerState userVisibleState() {
        return this.userVisibleState;
    }

    public ServerProperties withUserVisibleState(ServerState userVisibleState) {
        this.userVisibleState = userVisibleState;
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public ServerProperties withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        return this;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public ServerProperties withEarliestRestoreDate(OffsetDateTime earliestRestoreDate) {
        this.earliestRestoreDate = earliestRestoreDate;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ServerProperties withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String replicationRole() {
        return this.replicationRole;
    }

    public ServerProperties withReplicationRole(String replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public String masterServerId() {
        return this.masterServerId;
    }

    public ServerProperties withMasterServerId(String masterServerId) {
        this.masterServerId = masterServerId;
        return this;
    }

    public Integer replicaCapacity() {
        return this.replicaCapacity;
    }

    public ServerProperties withReplicaCapacity(Integer replicaCapacity) {
        this.replicaCapacity = replicaCapacity;
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerProperties withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeStringField("sslEnforcement", this.sslEnforcement == null ? null : this.sslEnforcement.toString());
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeStringField("infrastructureEncryption", this.infrastructureEncryption == null ? null : this.infrastructureEncryption.toString());
        jsonWriter.writeStringField("userVisibleState", this.userVisibleState == null ? null : this.userVisibleState.toString());
        jsonWriter.writeStringField("fullyQualifiedDomainName", this.fullyQualifiedDomainName);
        jsonWriter.writeStringField("earliestRestoreDate", this.earliestRestoreDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.earliestRestoreDate));
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeStringField("replicationRole", this.replicationRole);
        jsonWriter.writeStringField("masterServerId", this.masterServerId);
        jsonWriter.writeNumberField("replicaCapacity", (Number)this.replicaCapacity);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerProperties)jsonReader.readObject(reader -> {
            ServerProperties deserializedServerProperties = new ServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerProperties.version = ServerVersion.fromString(reader.getString());
                    continue;
                }
                if ("sslEnforcement".equals(fieldName)) {
                    deserializedServerProperties.sslEnforcement = SslEnforcementEnum.fromString(reader.getString());
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerProperties.minimalTlsVersion = MinimalTlsVersionEnum.fromString(reader.getString());
                    continue;
                }
                if ("byokEnforcement".equals(fieldName)) {
                    deserializedServerProperties.byokEnforcement = reader.getString();
                    continue;
                }
                if ("infrastructureEncryption".equals(fieldName)) {
                    deserializedServerProperties.infrastructureEncryption = InfrastructureEncryption.fromString(reader.getString());
                    continue;
                }
                if ("userVisibleState".equals(fieldName)) {
                    deserializedServerProperties.userVisibleState = ServerState.fromString(reader.getString());
                    continue;
                }
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedServerProperties.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedServerProperties.earliestRestoreDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedServerProperties.storageProfile = StorageProfile.fromJson(reader);
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerProperties.replicationRole = reader.getString();
                    continue;
                }
                if ("masterServerId".equals(fieldName)) {
                    deserializedServerProperties.masterServerId = reader.getString();
                    continue;
                }
                if ("replicaCapacity".equals(fieldName)) {
                    deserializedServerProperties.replicaCapacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerProperties.publicNetworkAccess = PublicNetworkAccessEnum.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedServerProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> ServerPrivateEndpointConnection.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerProperties;
        });
    }
}

