/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FirewallRuleProperties
implements JsonSerializable<FirewallRuleProperties> {
    private String startIpAddress;
    private String endIpAddress;
    private static final ClientLogger LOGGER = new ClientLogger(FirewallRuleProperties.class);

    public String startIpAddress() {
        return this.startIpAddress;
    }

    public FirewallRuleProperties withStartIpAddress(String startIpAddress) {
        this.startIpAddress = startIpAddress;
        return this;
    }

    public String endIpAddress() {
        return this.endIpAddress;
    }

    public FirewallRuleProperties withEndIpAddress(String endIpAddress) {
        this.endIpAddress = endIpAddress;
        return this;
    }

    public void validate() {
        if (this.startIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startIpAddress in model FirewallRuleProperties"));
        }
        if (this.endIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endIpAddress in model FirewallRuleProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startIpAddress", this.startIpAddress);
        jsonWriter.writeStringField("endIpAddress", this.endIpAddress);
        return jsonWriter.writeEndObject();
    }

    public static FirewallRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallRuleProperties)jsonReader.readObject(reader -> {
            FirewallRuleProperties deserializedFirewallRuleProperties = new FirewallRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startIpAddress".equals(fieldName)) {
                    deserializedFirewallRuleProperties.startIpAddress = reader.getString();
                    continue;
                }
                if ("endIpAddress".equals(fieldName)) {
                    deserializedFirewallRuleProperties.endIpAddress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallRuleProperties;
        });
    }
}

