/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.grpc;

import com.couchbase.client.core.deps.com.google.common.base.MoreObjects;
import com.couchbase.client.core.deps.com.google.common.base.Objects;
import com.couchbase.client.core.deps.com.google.common.base.Preconditions;
import com.couchbase.client.core.deps.com.google.errorprone.annotations.InlineMe;
import com.couchbase.client.core.deps.io.grpc.Attributes;
import com.couchbase.client.core.deps.io.grpc.ChannelLogger;
import com.couchbase.client.core.deps.io.grpc.EquivalentAddressGroup;
import com.couchbase.client.core.deps.io.grpc.ExperimentalApi;
import com.couchbase.client.core.deps.io.grpc.MetricRecorder;
import com.couchbase.client.core.deps.io.grpc.ProxyDetector;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.grpc.StatusOr;
import com.couchbase.client.core.deps.io.grpc.SynchronizationContext;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
public abstract class NameResolver {
    public abstract String getServiceAuthority();

    public void start(final Listener listener) {
        if (listener instanceof Listener2) {
            this.start((Listener2)listener);
        } else {
            this.start(new Listener2(){

                @Override
                public void onError(Status error) {
                    listener.onError(error);
                }

                @Override
                public void onResult(ResolutionResult resolutionResult) {
                    listener.onAddresses(resolutionResult.getAddressesOrError().getValue(), resolutionResult.getAttributes());
                }
            });
        }
    }

    public void start(Listener2 listener) {
        this.start((Listener)listener);
    }

    public abstract void shutdown();

    public void refresh() {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class ConfigOrError {
        private final Status status;
        private final Object config;

        public static ConfigOrError fromConfig(Object config) {
            return new ConfigOrError(config);
        }

        public static ConfigOrError fromError(Status status) {
            return new ConfigOrError(status);
        }

        private ConfigOrError(Object config) {
            this.config = Preconditions.checkNotNull(config, "config");
            this.status = null;
        }

        private ConfigOrError(Status status) {
            this.config = null;
            this.status = Preconditions.checkNotNull(status, "status");
            Preconditions.checkArgument(!status.isOk(), "cannot use OK status: %s", (Object)status);
        }

        @Nullable
        public Object getConfig() {
            return this.config;
        }

        @Nullable
        public Status getError() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigOrError that = (ConfigOrError)o;
            return Objects.equal(this.status, that.status) && Objects.equal(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hashCode(this.status, this.config);
        }

        public String toString() {
            if (this.config != null) {
                return MoreObjects.toStringHelper(this).add("config", this.config).toString();
            }
            assert (this.status != null);
            return MoreObjects.toStringHelper(this).add("error", this.status).toString();
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class ResolutionResult {
        private final StatusOr<List<EquivalentAddressGroup>> addressesOrError;
        private final Attributes attributes;
        @Nullable
        private final ConfigOrError serviceConfig;

        ResolutionResult(StatusOr<List<EquivalentAddressGroup>> addressesOrError, Attributes attributes, ConfigOrError serviceConfig) {
            this.addressesOrError = addressesOrError;
            this.attributes = Preconditions.checkNotNull(attributes, "attributes");
            this.serviceConfig = serviceConfig;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return ResolutionResult.newBuilder().setAddressesOrError(this.addressesOrError).setAttributes(this.attributes).setServiceConfig(this.serviceConfig);
        }

        @Deprecated
        public List<EquivalentAddressGroup> getAddresses() {
            return this.addressesOrError.getValue();
        }

        public StatusOr<List<EquivalentAddressGroup>> getAddressesOrError() {
            return this.addressesOrError;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        @Nullable
        public ConfigOrError getServiceConfig() {
            return this.serviceConfig;
        }

        public String toString() {
            MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this);
            stringHelper.add("addressesOrError", this.addressesOrError.toString());
            stringHelper.add("attributes", this.attributes);
            stringHelper.add("serviceConfigOrError", this.serviceConfig);
            return stringHelper.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResolutionResult)) {
                return false;
            }
            ResolutionResult that = (ResolutionResult)obj;
            return Objects.equal(this.addressesOrError, that.addressesOrError) && Objects.equal(this.attributes, that.attributes) && Objects.equal(this.serviceConfig, that.serviceConfig);
        }

        public int hashCode() {
            return Objects.hashCode(this.addressesOrError, this.attributes, this.serviceConfig);
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
        public static final class Builder {
            private StatusOr<List<EquivalentAddressGroup>> addresses = StatusOr.fromValue(Collections.emptyList());
            private Attributes attributes = Attributes.EMPTY;
            @Nullable
            private ConfigOrError serviceConfig;

            Builder() {
            }

            @Deprecated
            public Builder setAddresses(List<EquivalentAddressGroup> addresses) {
                this.setAddressesOrError(StatusOr.fromValue(addresses));
                return this;
            }

            public Builder setAddressesOrError(StatusOr<List<EquivalentAddressGroup>> addresses) {
                this.addresses = Preconditions.checkNotNull(addresses, "StatusOr addresses cannot be null.");
                return this;
            }

            public Builder setAttributes(Attributes attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder setServiceConfig(@Nullable ConfigOrError serviceConfig) {
                this.serviceConfig = serviceConfig;
                return this;
            }

            public ResolutionResult build() {
                return new ResolutionResult(this.addresses, this.attributes, this.serviceConfig);
            }
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class ServiceConfigParser {
        public abstract ConfigOrError parseServiceConfig(Map<String, ?> var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class Args {
        private final int defaultPort;
        private final ProxyDetector proxyDetector;
        private final SynchronizationContext syncContext;
        private final ServiceConfigParser serviceConfigParser;
        @Nullable
        private final ScheduledExecutorService scheduledExecutorService;
        @Nullable
        private final ChannelLogger channelLogger;
        @Nullable
        private final Executor executor;
        @Nullable
        private final String overrideAuthority;
        @Nullable
        private final MetricRecorder metricRecorder;

        private Args(Integer defaultPort, ProxyDetector proxyDetector, SynchronizationContext syncContext, ServiceConfigParser serviceConfigParser, @Nullable ScheduledExecutorService scheduledExecutorService, @Nullable ChannelLogger channelLogger, @Nullable Executor executor, @Nullable String overrideAuthority, @Nullable MetricRecorder metricRecorder) {
            this.defaultPort = Preconditions.checkNotNull(defaultPort, "defaultPort not set");
            this.proxyDetector = Preconditions.checkNotNull(proxyDetector, "proxyDetector not set");
            this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext not set");
            this.serviceConfigParser = Preconditions.checkNotNull(serviceConfigParser, "serviceConfigParser not set");
            this.scheduledExecutorService = scheduledExecutorService;
            this.channelLogger = channelLogger;
            this.executor = executor;
            this.overrideAuthority = overrideAuthority;
            this.metricRecorder = metricRecorder;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public ProxyDetector getProxyDetector() {
            return this.proxyDetector;
        }

        public SynchronizationContext getSynchronizationContext() {
            return this.syncContext;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6454")
        public ScheduledExecutorService getScheduledExecutorService() {
            if (this.scheduledExecutorService == null) {
                throw new IllegalStateException("ScheduledExecutorService not set in Builder");
            }
            return this.scheduledExecutorService;
        }

        public ServiceConfigParser getServiceConfigParser() {
            return this.serviceConfigParser;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6438")
        public ChannelLogger getChannelLogger() {
            if (this.channelLogger == null) {
                throw new IllegalStateException("ChannelLogger is not set in Builder");
            }
            return this.channelLogger;
        }

        @Nullable
        public Executor getOffloadExecutor() {
            return this.executor;
        }

        @Nullable
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9406")
        public String getOverrideAuthority() {
            return this.overrideAuthority;
        }

        @Nullable
        public MetricRecorder getMetricRecorder() {
            return this.metricRecorder;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("defaultPort", this.defaultPort).add("proxyDetector", this.proxyDetector).add("syncContext", this.syncContext).add("serviceConfigParser", this.serviceConfigParser).add("scheduledExecutorService", this.scheduledExecutorService).add("channelLogger", this.channelLogger).add("executor", this.executor).add("overrideAuthority", this.overrideAuthority).add("metricRecorder", this.metricRecorder).toString();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.setDefaultPort(this.defaultPort);
            builder.setProxyDetector(this.proxyDetector);
            builder.setSynchronizationContext(this.syncContext);
            builder.setServiceConfigParser(this.serviceConfigParser);
            builder.setScheduledExecutorService(this.scheduledExecutorService);
            builder.setChannelLogger(this.channelLogger);
            builder.setOffloadExecutor(this.executor);
            builder.setOverrideAuthority(this.overrideAuthority);
            builder.setMetricRecorder(this.metricRecorder);
            return builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Integer defaultPort;
            private ProxyDetector proxyDetector;
            private SynchronizationContext syncContext;
            private ServiceConfigParser serviceConfigParser;
            private ScheduledExecutorService scheduledExecutorService;
            private ChannelLogger channelLogger;
            private Executor executor;
            private String overrideAuthority;
            private MetricRecorder metricRecorder;

            Builder() {
            }

            public Builder setDefaultPort(int defaultPort) {
                this.defaultPort = defaultPort;
                return this;
            }

            public Builder setProxyDetector(ProxyDetector proxyDetector) {
                this.proxyDetector = Preconditions.checkNotNull(proxyDetector);
                return this;
            }

            public Builder setSynchronizationContext(SynchronizationContext syncContext) {
                this.syncContext = Preconditions.checkNotNull(syncContext);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6454")
            public Builder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
                this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService);
                return this;
            }

            public Builder setServiceConfigParser(ServiceConfigParser parser) {
                this.serviceConfigParser = Preconditions.checkNotNull(parser);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6438")
            public Builder setChannelLogger(ChannelLogger channelLogger) {
                this.channelLogger = Preconditions.checkNotNull(channelLogger);
                return this;
            }

            public Builder setOffloadExecutor(Executor executor) {
                this.executor = executor;
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9406")
            public Builder setOverrideAuthority(String authority) {
                this.overrideAuthority = authority;
                return this;
            }

            public Builder setMetricRecorder(MetricRecorder metricRecorder) {
                this.metricRecorder = metricRecorder;
                return this;
            }

            public Args build() {
                return new Args(this.defaultPort, this.proxyDetector, this.syncContext, this.serviceConfigParser, this.scheduledExecutorService, this.channelLogger, this.executor, this.overrideAuthority, this.metricRecorder);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4972")
    public static @interface ResolutionResultAttr {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Listener2
    implements Listener {
        @Override
        @Deprecated
        @InlineMe(replacement="this.onResult(ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue(servers)).setAttributes(attributes).build())", imports={"com.couchbase.client.core.deps.io.grpc.NameResolver.ResolutionResult", "com.couchbase.client.core.deps.io.grpc.StatusOr"})
        public final void onAddresses(List<EquivalentAddressGroup> servers, Attributes attributes) {
            this.onResult(ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue(servers)).setAttributes(attributes).build());
        }

        public abstract void onResult(ResolutionResult var1);

        @Override
        public abstract void onError(Status var1);

        public Status onResult2(ResolutionResult resolutionResult) {
            this.onResult(resolutionResult);
            return Status.OK;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    @ThreadSafe
    public static interface Listener {
        public void onAddresses(List<EquivalentAddressGroup> var1, Attributes var2);

        public void onError(Status var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Factory {
        public abstract NameResolver newNameResolver(URI var1, Args var2);

        public abstract String getDefaultScheme();
    }
}

