/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.dbeaver.db.cosmos.nosql.DCosmosContainer;
import com.dbeaver.db.cosmos.nosql.DCosmosDatabase;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLExecutionContext;
import com.dbeaver.db.cosmos.nosql.exec.DCosmosSelectStatement;
import com.dbeaver.db.cosmos.nosql.model.DCosmosContainerHint;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class DCosmosSession
extends AbstractSession {
    @NotNull
    private final DCosmosNoSQLExecutionContext exceutionContext;

    public DCosmosSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle, @NotNull DCosmosNoSQLExecutionContext exceutionContext) {
        super(monitor, purpose, taskTitle);
        this.exceutionContext = exceutionContext;
    }

    @NotNull
    public DCosmosNoSQLExecutionContext getExecutionContext() {
        return this.exceutionContext;
    }

    @NotNull
    public DCosmosNoSQLDataSource getDataSource() {
        return (DCosmosNoSQLDataSource)this.exceutionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        String[] comments = SQLUtils.extractComments((SQLDialect)this.getDataSource().getSQLDialect(), (String)query);
        String strippedQuery = SQLUtils.stripComments((SQLDialect)this.getDataSource().getSQLDialect(), (String)query);
        DCosmosDatabase defaultCatalog = this.getExecutionContext().getContextDefaults().getDefaultCatalog();
        String defaultDatabase = defaultCatalog != null ? defaultCatalog.getName() : null;
        DCosmosContainerHint containerInfo = DCosmosSession.fromComments(comments).or(() -> this.fromQuery(defaultDatabase, strippedQuery)).orElseThrow(() -> new DBCException("Container hint is required.\nAdd a comment with container hint to the query like this: '-- cosmos:db=databaseId container=containerId';\nOr use fully qualified container name like this: 'select * from databaseId.containerId'\n"));
        String normalizedQuery = this.normalizeQuery(containerInfo, strippedQuery);
        try {
            return this.prepareStatement0(type, containerInfo, normalizedQuery, scrollable, updatable, returnGeneratedKeys);
        }
        catch (DBException e) {
            throw new DBCException("Error executing statement: " + normalizedQuery + ";\nError: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Optional<DCosmosContainerHint> fromComments(String[] comments) {
        return Arrays.stream(comments).filter(comment -> comment.startsWith("cosmos:")).map(DCosmosContainerHint::parseComment).filter(Objects::nonNull).findFirst();
    }

    private Optional<DCosmosContainerHint> fromQuery(@Nullable String defaultDatabase, @NotNull String query) {
        DCosmosContainerHint hint = DCosmosContainerHint.extractFromQuery(defaultDatabase, query);
        return Optional.ofNullable(hint);
    }

    private String normalizeQuery(@NotNull DCosmosContainerHint hint, @NotNull String query) {
        return query.replace(hint.databaseId() + ".", "");
    }

    @NotNull
    private DBCStatement prepareStatement0(@NotNull DBCStatementType type, @NotNull DCosmosContainerHint hint, @NotNull String normalizedQuery, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBException {
        String queryCommand;
        DCosmosDatabase dCosmosDatabase = this.getDataSource().getChild(this.getProgressMonitor(), hint.databaseId());
        if (dCosmosDatabase == null) {
            throw new DBException("Database '" + hint.databaseId() + "' not found");
        }
        DCosmosContainer container = dCosmosDatabase.getChild(this.getProgressMonitor(), hint.containerId());
        if (container == null) {
            throw new DBException("Container '" + hint.containerId() + "' not found");
        }
        switch (queryCommand = normalizedQuery.substring(0, normalizedQuery.indexOf(" ")).toUpperCase(Locale.ENGLISH)) {
            case "SELECT": {
                return new DCosmosSelectStatement(this, this.getDataSource(), container, normalizedQuery);
            }
        }
        throw new DBCException("Unsupported query type: " + queryCommand);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
    }
}

