/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ThroughputResponse;
import com.dbeaver.db.cosmos.nosql.DCosmosContainerProperties;
import com.dbeaver.db.cosmos.nosql.DCosmosDatabase;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import com.dbeaver.db.cosmos.nosql.DCosmosSession;
import com.dbeaver.db.cosmos.nosql.DCosmosThroughputProperties;
import com.dbeaver.db.cosmos.nosql.exec.DCosmosSelectStatement;
import com.dbeaver.model.document.DBAbstractDocumentContainer;
import java.util.concurrent.atomic.AtomicReference;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DCosmosContainer
extends DBAbstractDocumentContainer<DCosmosNoSQLDataSource> {
    private static final Log log = Log.getLog(DCosmosContainer.class);
    @NotNull
    private final String id;
    @NotNull
    private final DCosmosDatabase database;
    @NotNull
    private final AtomicReference<DCosmosContainerProperties> propertiesRef = new AtomicReference();
    @NotNull
    private final AtomicReference<DCosmosThroughputProperties> throughputRef = new AtomicReference();

    public DCosmosContainer(@NotNull String id, @NotNull DCosmosDatabase database, @NotNull DCosmosNoSQLDataSource dataSource) {
        super((DBPDataSource)dataSource);
        this.id = id;
        this.database = database;
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count", "data.filter"};
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        long startTime = System.currentTimeMillis();
        String query = this.buildQuery("SELECT * FROM c", dataFilter);
        try {
            Throwable throwable = null;
            Object var17_15 = null;
            try (DCosmosSelectStatement statement = new DCosmosSelectStatement((DCosmosSession)session, (DCosmosNoSQLDataSource)this.dataSource, this, query);){
                statement.setLimit(firstRow, maxRows);
                statement.setResultsFetchSize(fetchSize);
                statement.executeStatement();
                DBCResultSet resultSet = statement.openResultSet();
                if (resultSet != null) {
                    DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                    DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (DBCStatistics)statistics);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            throw new DBCException("Error reading table data", (Throwable)e, session.getExecutionContext());
        }
        statistics.setQueryText(query);
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        String query = this.buildQuery("SELECT VALUE COUNT(1) FROM c", dataFilter);
        return (Long)((DCosmosNoSQLDataSource)this.dataSource).getClient().getDatabase(this.database.getName()).getContainer(this.id).queryItems(query, new CosmosQueryRequestOptions(), Long.class).take(1L).blockFirst();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public DBSObject getParentObject() {
        return this.database;
    }

    @Nullable
    public String getDescription() {
        return "";
    }

    public boolean isPersisted() {
        return true;
    }

    @PropertyGroup(category="Properties", order=1)
    @LazyProperty(cacheValidator=PropertiesValidator.class)
    public DCosmosContainerProperties getProperties(DBRProgressMonitor monitor) throws DBCException {
        return this.propertiesRef.updateAndGet(oldValue -> {
            if (oldValue != null) {
                return oldValue;
            }
            return this.loadProperties();
        });
    }

    @PropertyGroup(category="Throughput", order=2)
    @LazyProperty(cacheValidator=ThroughputValidator.class)
    public DCosmosThroughputProperties getThroughput(DBRProgressMonitor monitor) throws DBCException {
        return this.throughputRef.updateAndGet(oldValue -> {
            if (oldValue != null) {
                return oldValue;
            }
            try {
                return this.loadThroughput();
            }
            catch (Exception exception) {
                return DCosmosThroughputProperties.UNKNOWN;
            }
        });
    }

    public String toString() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    private String buildQuery(@NotNull String baseQuery, @Nullable DBDDataFilter dataFilter) throws DBCException {
        try {
            StringBuilder queryBuilder = new StringBuilder(baseQuery);
            if (dataFilter != null && dataFilter.hasConditions()) {
                queryBuilder.append(" WHERE ");
                SQLUtils.appendConditionString((DBDDataFilter)dataFilter, (DBPDataSource)this.dataSource, null, (StringBuilder)queryBuilder, (boolean)true);
            }
            if (dataFilter != null && dataFilter.hasOrdering()) {
                queryBuilder.append(" ORDER BY ");
                SQLUtils.appendOrderString((DBDDataFilter)dataFilter, (DBPDataSource)this.dataSource, null, (boolean)false, (StringBuilder)queryBuilder);
            }
            return queryBuilder.toString();
        }
        catch (Exception e) {
            throw new DBCException("Error building query for container '" + this.id + "'", (Throwable)e);
        }
    }

    private DCosmosContainerProperties loadProperties() {
        return this.database.getDataSource().getClient().getDatabase(this.database.getName()).getContainer(this.id).read().blockOptional().map(CosmosContainerResponse::getProperties).map(DCosmosContainerProperties::fromProperties).orElse(null);
    }

    private DCosmosThroughputProperties loadThroughput() {
        return this.database.getDataSource().getClient().getDatabase(this.database.getName()).getContainer(this.id).readThroughput().blockOptional().map(ThroughputResponse::getProperties).map(DCosmosThroughputProperties::fromProperties).orElse(null);
    }

    public static class PropertiesValidator
    implements IPropertyCacheValidator<DCosmosContainer> {
        public PropertiesValidator() {
            System.out.println("PropertiesValidator created");
        }

        public boolean isPropertyCached(@NotNull DCosmosContainer object, @NotNull Object propertyId) {
            return object.propertiesRef.get() != null;
        }
    }

    public static class ThroughputValidator
    implements IPropertyCacheValidator<DCosmosContainer> {
        public boolean isPropertyCached(@NotNull DCosmosContainer object, @NotNull Object propertyId) {
            return object.throughputRef.get() != null;
        }
    }
}

