/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CasDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(CasDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.cassandra-driver";
    private final Metadata metadata;

    public CasDataSourceInfo(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getDatabaseProductName() {
        return "Cassandra";
    }

    public String getDatabaseProductVersion() {
        StringBuilder version = new StringBuilder();
        HashSet<String> visitedVersions = new HashSet<String>();
        Map allHosts = this.metadata.getNodes();
        for (Map.Entry host : allHosts.entrySet()) {
            String hostVersion;
            com.datastax.oss.driver.api.core.Version cassandraVersion = ((Node)host.getValue()).getCassandraVersion();
            String string = hostVersion = cassandraVersion == null ? "?" : cassandraVersion.toString();
            if (visitedVersions.contains(hostVersion)) continue;
            visitedVersions.add(hostVersion);
            if (version.length() > 0) {
                version.append(",");
            }
            version.append(hostVersion);
        }
        return version.toString();
    }

    public Map<String, Object> getDatabaseProductDetails() {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList hosts = new ArrayList();
        details.put("Cluster", this.metadata.getClusterName().orElse(null));
        details.put("Partitioner", ((TokenMap)this.metadata.getTokenMap().get()).getPartitionerName());
        details.put("Hosts", hosts);
        Map allHosts = this.metadata.getNodes();
        for (Map.Entry host : allHosts.entrySet()) {
            LinkedHashMap<String, Object> hostInfo = new LinkedHashMap<String, Object>();
            hosts.add(hostInfo);
            hostInfo.put("ID", ((Node)host.getValue()).getHostId());
            hostInfo.put("Address", ((Node)host.getValue()).getBroadcastAddress());
            hostInfo.put("Cassandra Version", ((Node)host.getValue()).getCassandraVersion());
            hostInfo.put("Schema Version", ((Node)host.getValue()).getSchemaVersion());
            hostInfo.put("Datacenter", ((Node)host.getValue()).getDatacenter());
            hostInfo.put("Rack", ((Node)host.getValue()).getRack());
        }
        return details;
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Cassandra driver bundle 'org.jkiss.bundle.cassandra-driver' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        return this.getDriverBundle().getVersion();
    }

    public String getDriverName() {
        return (String)this.getDriverBundle().getHeaders().get("Bundle-Name");
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Keyspace";
    }

    public boolean supportsIndexes() {
        return true;
    }
}

