/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data;

import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.dbeaver.db.cassandra.data.CasCollectionValue;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasDataType;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFixedSizeCollection;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasVectorValue
extends CasCollectionValue
implements DBDValueCloneable,
DBDFixedSizeCollection {
    private static final Map<Class<? extends Number>, Number> DEFAULT_VALUES = Map.of(Byte.class, (byte)0, Short.class, (short)0, Integer.class, 0, Long.class, 0L, Float.class, Float.valueOf(0.0f), Double.class, 0.0, BigDecimal.class, BigDecimal.ZERO, BigInteger.class, BigInteger.ZERO);
    private final int dimensions;
    private CqlVector<? extends Number> vector;
    private final VectorType vectorType;
    private final CasDataType componentType;
    private boolean modified;

    public CasVectorValue(@NotNull CasExecutionContext executionContext, @NotNull String keyspace, CqlVector<? extends Number> vector, VectorType vectorType) throws DBCException {
        super(executionContext, keyspace);
        this.vectorType = vectorType;
        this.dimensions = vectorType.getDimensions();
        this.componentType = (CasDataType)((CasDataSource)executionContext.getDataSource()).getLocalDataType(vectorType.getElementType().getProtocolCode());
        this.vector = vector;
    }

    public CasVectorValue(CasVectorValue object) throws DBCException {
        super(object);
        this.dimensions = object.dimensions;
        this.vectorType = object.vectorType;
        this.componentType = object.componentType;
        this.modified = object.modified;
        this.vector = object.vector == null ? CqlVector.newInstance(this.createEmptyVectorArray()) : CqlVector.newInstance(object.vector.stream().collect(Collectors.toList()));
    }

    public boolean canSetElementsToNull() {
        return false;
    }

    public Object populateCollection() throws DBCException {
        CasVectorValue objects = new CasVectorValue(this);
        objects.vector = CqlVector.newInstance(this.createEmptyVectorArray());
        objects.modified = true;
        return objects;
    }

    private <T extends Number> List<T> createEmptyVectorArray() throws DBCException {
        Class<? extends Number> type = CasVectorValue.getElementClass(this.getElementType());
        Number value = DEFAULT_VALUES.get(type);
        if (value == null) {
            throw new DBCException("Unsupported number type: " + String.valueOf(type));
        }
        ArrayList<Number> values = new ArrayList<Number>(this.dimensions);
        int i = 0;
        while (i < this.dimensions) {
            values.add(value);
            ++i;
        }
        return values;
    }

    @NotNull
    public static Class<? extends Number> getElementClass(DataType type) {
        return CodecRegistry.DEFAULT.codecFor(type).getJavaType().getRawType().asSubclass(Number.class);
    }

    public DataType getElementType() {
        return this.vectorType.getElementType();
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.componentType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.executionContext.getDataSource(), (DBSTypedObject)this.componentType);
    }

    public int getItemCount() {
        return this.vector == null ? 0 : this.dimensions;
    }

    public Object getItem(int index) {
        return this.vector.get(index);
    }

    public void setItem(int index, Object value) {
        this.vector.set(index, this.wrapToNumber(value));
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        if (this.vector == null) {
            this.vector = CqlVector.newInstance(this.wrapToNumberList(contents));
        } else {
            int i = 0;
            while (i < contents.length) {
                this.setItem(i, contents[i]);
                ++i;
            }
        }
        this.modified = true;
    }

    private <ELEMENT_CLASS extends Number> ELEMENT_CLASS wrapToNumber(Object item) {
        return (ELEMENT_CLASS)((Number)item);
    }

    private <ELEMENT_CLASS extends Number> List<ELEMENT_CLASS> wrapToNumberList(Object[] contents) {
        ArrayList<Number> wrappedArray = new ArrayList<Number>();
        Object[] objectArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            Object content = objectArray[n2];
            wrappedArray.add((Number)content);
            ++n2;
        }
        return wrappedArray;
    }

    public Object getRawValue() {
        return this.vector;
    }

    public boolean isNull() {
        return this.vector == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.vector = null;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new CasVectorValue(this);
    }

    public <ELEMENT_CLASS extends Number> CqlVector<ELEMENT_CLASS> makeVector() {
        return this.vector;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        DBDValueHandler cvh = this.getComponentValueHandler();
        StringBuilder str = new StringBuilder(this.vector.size() * 32);
        str.append("[");
        int i = 0;
        while (i < this.vector.size()) {
            Number item = this.vector.get(i);
            if (i > 0) {
                str.append(',');
            }
            String itemString = cvh.getValueDisplayString((DBSTypedObject)this.componentType, (Object)item, DBDDisplayFormat.NATIVE);
            SQLUtils.appendValue((StringBuilder)str, (DBSTypedObject)this.componentType, (Object)itemString);
            ++i;
        }
        str.append("]");
        return str.toString();
    }
}

