/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class TimestreamWriteEndpointDiscoveryCacheLoader
implements EndpointDiscoveryCacheLoader {
    private final TimestreamWriteClient client;

    private TimestreamWriteEndpointDiscoveryCacheLoader(TimestreamWriteClient client) {
        this.client = client;
    }

    public static TimestreamWriteEndpointDiscoveryCacheLoader create(TimestreamWriteClient client) {
        return new TimestreamWriteEndpointDiscoveryCacheLoader(client);
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        return CompletableFuture.supplyAsync(() -> {
            AwsRequestOverrideConfiguration requestConfig = AwsRequestOverrideConfiguration.from((RequestOverrideConfiguration)endpointDiscoveryRequest.overrideConfiguration().orElse(null));
            DescribeEndpointsResponse response = this.client.describeEndpoints((DescribeEndpointsRequest)((Object)((Object)DescribeEndpointsRequest.builder().overrideConfiguration(requestConfig).build())));
            List<Endpoint> endpoints = response.endpoints();
            Validate.notEmpty(endpoints, (String)"Endpoints returned by service for endpoint discovery must not be empty.", (Object[])new Object[0]);
            Endpoint endpoint = endpoints.get(0);
            return EndpointDiscoveryEndpoint.builder().endpoint(this.toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint())).expirationTime(Instant.now().plus((long)endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES)).build();
        });
    }
}

