/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.FirestoreUtils;
import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.exec.FireStoreBaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.DocumentReference;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class FireStoreUpdateStatement
extends FireStoreBaseStatement {
    private final DBSAttributeBase[] valueAttributes;
    private final FireStoreCollection collection;
    private final DBSAttributeBase[] keyAttributes;
    private final List<Object[]> rowValues = new ArrayList<Object[]>();

    public FireStoreUpdateStatement(FireStoreSession session, FireStoreCollection database, DBSAttributeBase[] valueAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, null);
        this.collection = database;
        this.keyAttributes = keyAttributes;
        this.valueAttributes = valueAttributes;
    }

    public void addRowValues(Object[] rowValues) {
        this.rowValues.add(rowValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeStatement() throws DBCException {
        try {
            boolean docUpdate = this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT;
            for (Object[] row : this.rowValues) {
                if (docUpdate) {
                    FireStoreDocument fireStoreDocument;
                    Map<String, Object> docMap;
                    Object object = row[0];
                    if (object instanceof FireStoreDocument) {
                        FireStoreDocument documentRow = (FireStoreDocument)((Object)object);
                        docMap = (Map<String, Object>)documentRow.getRawValue();
                        fireStoreDocument = documentRow;
                    } else {
                        Object object2 = row[0];
                        if (!(object2 instanceof String)) throw new DBCException("Error reading value: %s".formatted(row[0]));
                        String json = (String)object2;
                        try {
                            Throwable throwable = null;
                            Object var11_14 = null;
                            try (StringReader reader = new StringReader(json);){
                                docMap = ((FireStoreDatasource)((FireStoreSession)this.getSession()).getDataSource()).deserializeDocument(reader);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                    throw throwable;
                                } else {
                                    if (throwable == throwable2) throw throwable;
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {
                            throw new DBCException("Failure deserializing : %s".formatted(row[0]));
                        }
                        fireStoreDocument = (FireStoreDocument)((Object)row[1]);
                    }
                    String docId = null;
                    if (fireStoreDocument.getPath() == null && ((Map)fireStoreDocument.getRawValue()).isEmpty()) {
                        var12_16 = row[0];
                        if (!(var12_16 instanceof FireStoreDocument)) throw new DBCException("Document path not found " + String.valueOf(fireStoreDocument.getDocumentId()));
                        FireStoreDocument storeDocument = (FireStoreDocument)((Object)var12_16);
                        ApiFuture document = ((FireStoreSession)this.getSession()).getExecutionContext().getService().collection(this.collection.getPath()).add(new HashMap());
                        DocumentReference documentReference = (DocumentReference)document.get(20L, TimeUnit.SECONDS);
                        storeDocument.setId(documentReference.getId());
                        storeDocument.setPath(documentReference.getPath());
                    } else {
                        FireStoreDocument originalFireStoreDocument;
                        Object docIdObj;
                        var12_16 = row[1];
                        if (var12_16 instanceof FireStoreDocument && (docIdObj = ((Map)(originalFireStoreDocument = (FireStoreDocument)((Object)var12_16)).getRawValue()).get("__name__")) != null) {
                            docId = docIdObj.toString();
                            fireStoreDocument.setId(docId);
                        }
                    }
                    docMap = FirestoreUtils.cleanupDocumentMapProperties(docMap);
                    DocumentReference document = null;
                    if (fireStoreDocument.getPath() != null) {
                        document = ((FireStoreSession)this.getSession()).getExecutionContext().getService().document(fireStoreDocument.getPath());
                    }
                    if (docId != null) {
                        document = ((FireStoreSession)this.getSession()).getExecutionContext().getService().document(this.collection.getPath() + "/" + docId);
                    }
                    if (document == null) throw new DBCException("Document with id " + String.valueOf(fireStoreDocument.getDocumentId()) + " doesn't exist");
                    document.set(docMap).get(20L, TimeUnit.SECONDS);
                    continue;
                }
                HashMap<String, Object> setMap = new HashMap<String, Object>();
                Object id = null;
                int i = 0;
                while (i < this.keyAttributes.length) {
                    Object keyValue = row[this.valueAttributes.length + i];
                    if (!(keyValue instanceof FireStoreDocument)) {
                        throw new DBCException("Null document ID specified");
                    }
                    FireStoreDocument document = (FireStoreDocument)((Object)keyValue);
                    id = document.getDocumentId();
                    ++i;
                }
                i = 0;
                while (i < this.valueAttributes.length) {
                    setMap.put(this.valueAttributes[i].getName(), row[i]);
                    ++i;
                }
                ((FireStoreSession)this.getSession()).getExecutionContext().getService().document(this.collection.getPath() + "/" + String.valueOf(id)).update(setMap).get(20L, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.rowValues.clear();
        }
    }

    public DBSEntity getSourceEntity() {
        return this.collection;
    }
}

